package com.atlassian.confluence.ext.usage;

import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;

import static java.util.Arrays.stream;
import static org.apache.commons.lang3.StringUtils.isBlank;

/**
 * @since 2.0.0
 */
public enum UsagePeriod {

    HOURLY("h|(?i:hour|hourly)", Hour.class),
    DAILY("d|(?i:day|daily)", Day.class),
    WEEKLY("w|(?i:week|weekly)", Week.class),
    MONTHLY("M|(?i:month|monthly)", Month.class),
    MINUTELY("m|(?i:minute|minutely)", Minute.class),
    QUARTERLY("q|(?i:quarter|quarterly)", Quarter.class),
    YEARLY("y|(?i:year|yearly)", Year.class);

    private final String regex;
    private final Class type;

    UsagePeriod(String regex, Class type) {
        this.regex = regex;
        this.type = type;
    }

    public static UsagePeriod resolve(final String value) {
        if (isBlank(value)) {
            return DAILY;
        }
        return stream(values())
                .filter(period -> value.matches(period.regex))
                .findFirst()
                .orElse(DAILY);
    }

    public Class getType() {
        return type;
    }
}
