<%@ page import="com.atlassian.config.ConfigurationException,
                 com.atlassian.confluence.core.ConfluenceSidManager,
                 com.atlassian.johnson.JohnsonEventContainer,
                 com.atlassian.johnson.event.Event,
                 com.atlassian.spring.container.ContainerManager"%>
<%@ page import="java.util.Collection" %>
<%@ page import="java.util.Iterator" %>

<html>
<head>
    <title>Errors</title>
</head>
<body leftmargin="0" topmargin="0" marginwidth="0" marginheight="0">
<table border="0" cellpadding="0" cellspacing="0" width=100%>
    <tr>
        <td height=10></td>
        <%
                String sid = null;
                if (ContainerManager.isContainerSetup())
                {
                    ConfluenceSidManager sidManager = (ConfluenceSidManager) ContainerManager.getComponent("sidManager");
                    try
                    {
                        sid = sidManager.getSid();
                    }
                    catch (ConfigurationException e)
                    {
                        // ignore, we just don't want this to bomb out this page 
                    }
                }

                JohnsonEventContainer appEventContainer = JohnsonEventContainer.get(pageContext.getServletContext());
                //if there are Events outstanding then set the HTTP return code to 500 Internal Server Error
                if (appEventContainer != null && appEventContainer.hasEvents())
                {
                    response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
                    response.flushBuffer(); // needed otherwise an exception is thrown
                }
                //if there are Events outstanding then display them in a table
                if (appEventContainer != null && appEventContainer.hasEvents())
                {
            %>
                        <content tag="headsection">
                            <meta http-equiv="Refresh" content="10;"/>
                        </content>

                        <font color="cc0000">You cannot access Confluence at present. Look at the table below to identify the reasons</font>
                        <p></p>
                    <br>
                    <table align=center bgcolor="bbbbbb" border="0" cellpadding="0" cellspacing="0" width=100%>
                    <tr>
                        <td>
                            <table  border="0" cellpadding="3" cellspacing="1" width=100%>

                                <tr bgcolor="#f0f0f0">
                                    <td class="colHeaderLink" nowrap>
                                        <b>Time</b>
                                    </td>
                                    <td class="colHeaderLink">
                                        <b>Level</b>
                                    </td>
                                    <td class="colHeaderLink">
                                        <b>Type</b>
                                    </td>
                                    <td class="colHeaderLink" width=40%>
                                        <b>Description</b>
                                    </td>
                                    <td class="colHeaderLink" width=40%>
                                        <b>Exception</b>
                                    </td>
                                </tr>

                                <%
                                    Collection events  = appEventContainer.getEvents();
                                    int counter = 1;
                                    for (Iterator iterator = events.iterator(); iterator.hasNext();)
                                    {
                                        Event event = (Event) iterator.next();

                                        if (counter % 2 == 1) {
                                        %>
                                            <tr bgcolor="#fffff0">
                                        <%} else { %>
                                            <tr bgcolor="#ffffff">
                                        <% } %>
                                            <td nowrap><%=event.getDate()%></td>
                                            <td nowrap><%=event.getLevel()%> </td>
                                            <td nowrap><%=event.getKey()%></td>
                                            <td><%=event.getDesc()%><%= (sid == null ? " No server id found." : " Your server id is: <strong>" + sid + "</strong>.") %></td>
                                            <td><pre><%=event.getException()==null?"":event.getException()%></pre></td>
                                        </tr>

                                        <% counter++;
                                        }

                                    %>
                            </table>
                        </td>
                    </tr>
                    </table>
                    <br>
                <% } else { %>
                        <p>There are no problems accessing Confluence at present.</p>
                 <% } %>
        </tr>
    </table>
    </body>
</html>
