/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.v2.api.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.rest.v2.api.model.validation.RestValidationResult;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.ws.rs.core.Response;
import org.checkerframework.checker.nullness.qual.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
@ExperimentalApi
public class RestError {
    @JsonProperty
    private final int statusCode;
    @JsonProperty
    private final RestValidationResult data;
    @JsonProperty
    private final String message;
    @JsonProperty
    private final String reason;

    @JsonCreator
    private RestError() {
        this.statusCode = 0;
        this.data = null;
        this.message = null;
        this.reason = null;
    }

    RestError(Response.StatusType statusType, String message, @Nullable RestValidationResult data) {
        this(statusType.getStatusCode(), statusType.getReasonPhrase(), message, data);
    }

    RestError(int status, String message, @Nullable RestValidationResult data) {
        this(status, null, message, data);
    }

    RestError(int status, String reason, String message, @Nullable RestValidationResult data) {
        this.statusCode = status;
        this.message = message;
        this.data = data;
        this.reason = reason;
    }

    public @Nullable ValidationResult getData() {
        return this.data;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getReason() {
        return this.reason;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int statusCode;
        private RestValidationResult data;
        private String message;
        private String reason;

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder data(RestValidationResult data) {
            this.data = data;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public RestError build() {
            return new RestError(this.statusCode, this.reason, this.message, this.data);
        }
    }
}

