/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.serialization;

import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.reference.Collapsed;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.atlassian.confluence.api.serialization.RestEnrichableProperty;
import com.atlassian.confluence.rest.api.model.RestEntity;
import com.atlassian.confluence.rest.api.model.RestList;
import com.atlassian.confluence.rest.api.services.RestEntityFactory;
import com.atlassian.fugue.Option;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

public class DefaultRestEntityFactory
implements RestEntityFactory {
    public <T> RestEntity<T> create(T entity) {
        if (entity instanceof Map) {
            return this.createFromMap(entity);
        }
        return this.createFromIntrospection(entity);
    }

    private <T> RestEntity<T> createFromIntrospection(T entity) {
        RestEntity restEntity = new RestEntity(entity);
        try {
            for (Class<?> clazz = entity.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
                this.resolveClassProperties(restEntity, entity, clazz);
            }
        }
        catch (IllegalAccessException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
        return restEntity;
    }

    private <T> void resolveClassProperties(RestEntity<T> restEntity, T entity, Class<?> clazz) throws IllegalAccessException {
        for (Field field : clazz.getDeclaredFields()) {
            if (!this.isRestEntityProperty(field)) continue;
            field.setAccessible(true);
            String fieldName = field.getName();
            if (restEntity.hasProperty(fieldName)) {
                throw new IllegalStateException(String.format("JsonProperty-annotated fields in API Model classes *must not* shadow fields in superclasses, but %s shadows the field %s", clazz, fieldName));
            }
            Object fieldValue = field.get(entity);
            this.resolveProperty(restEntity, fieldName, fieldValue);
        }
    }

    private boolean isRestEntityProperty(Field field) {
        return field.isAnnotationPresent(JsonProperty.class) || field.isAnnotationPresent(RestEnrichableProperty.class);
    }

    private <T> RestEntity<T> createFromMap(T entity) {
        Map mapEntity = (Map)entity;
        RestEntity restEntity = new RestEntity(entity);
        for (Map.Entry o : mapEntity.entrySet()) {
            String fieldName = String.valueOf(o.getKey());
            Object fieldValue = o.getValue();
            this.resolveProperty(restEntity, fieldName, fieldValue);
        }
        if (mapEntity instanceof EnrichableMap) {
            EnrichableMap enrichableMap = (EnrichableMap)mapEntity;
            for (Object o : enrichableMap.getCollapsedEntries()) {
                this.resolveCollapsedProperty(restEntity, String.valueOf(o), navigationService -> null);
            }
        }
        return restEntity;
    }

    private <T> void resolveProperty(RestEntity<T> restEntity, String fieldName, Object fieldValue) {
        try {
            if (fieldValue instanceof Collapsed) {
                this.resolveCollapsedProperty(restEntity, fieldName, (Collapsed)fieldValue);
            } else if (fieldValue instanceof Reference) {
                this.resolveReferenceProperty(restEntity, fieldName, (Reference)fieldValue);
            } else if (fieldValue != null) {
                this.putIfValueNotNull(restEntity, fieldName, this.createPropertyValue(fieldValue));
            }
        }
        catch (IllegalAccessException ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    private <T> void resolveCollapsedProperty(RestEntity<T> restEntity, String propertyName, Collapsed value) {
        Map expandables = (Map)restEntity.getProperty("_expandable");
        if (expandables == null) {
            expandables = Maps.newHashMap();
            this.putIfValueNotNull(restEntity, "_expandable", expandables);
        }
        expandables.put(propertyName, value);
    }

    private void putIfValueNotNull(RestEntity entity, String key, Object value) {
        if (value != null) {
            entity.putProperty(key, value);
        }
    }

    private <T> void resolveReferenceProperty(RestEntity<T> restEntity, String propertyName, Reference<?> reference) throws IllegalAccessException {
        if (reference.exists() && reference.isExpanded()) {
            Object toAdd = this.createPropertyValue(reference.get());
            this.putIfValueNotNull(restEntity, propertyName, toAdd);
        }
    }

    private Iterable createIterableProperty(Iterable value) throws IllegalAccessException {
        if (value instanceof Option) {
            Option option = (Option)value;
            if (option.isDefined()) {
                Object propertyValue = this.createPropertyValue(option.get());
                if (propertyValue != null) {
                    return Option.some((Object)propertyValue);
                }
            } else {
                return null;
            }
        }
        boolean hasEnrichedEntities = false;
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (Object obj : value) {
            Object enriched = this.createPropertyValue(obj);
            hasEnrichedEntities |= enriched != obj;
            if (enriched == null) continue;
            listBuilder.add(enriched);
        }
        if (!hasEnrichedEntities) {
            return value;
        }
        ImmutableList enrichedList = listBuilder.build();
        if (value instanceof RestList || value instanceof PageResponse && RestEnrichable.Helper.isAnnotationOnClass((Object)value)) {
            PageResponse orig = (PageResponse)value;
            return RestList.newRestList((PageRequest)orig.getPageRequest()).results((List)enrichedList, orig.hasMore()).build();
        }
        return enrichedList;
    }

    private Map createMapProperty(Map<?, ?> value) throws IllegalAccessException {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        boolean hasRestEntity = false;
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue == null) continue;
            Object enriched = this.createPropertyValue(entryValue);
            hasRestEntity |= enriched != entryValue;
            if (enriched == null) continue;
            mapBuilder.put(entry.getKey(), enriched);
        }
        if (hasRestEntity) {
            return mapBuilder.build();
        }
        return value;
    }

    private Object createPropertyValue(Object value) throws IllegalAccessException {
        if (RestEnrichable.Helper.isAnnotationOnClass((Object)value)) {
            return this.create(value);
        }
        if (value instanceof Collapsed) {
            return value;
        }
        if (value instanceof Map) {
            return this.createMapProperty((Map)value);
        }
        if (value instanceof Iterable) {
            return this.createIterableProperty((Iterable)value);
        }
        return value;
    }
}

