/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.api.model.validation;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.validation.SimpleFieldValidationError;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationError;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.rest.api.model.validation.RestFieldValidationError;
import com.atlassian.confluence.rest.api.model.validation.RestValidationError;
import com.atlassian.confluence.rest.api.model.validation.ValidationErrorDeserializer;
import com.atlassian.confluence.rest.api.model.validation.ValidationErrorDeserializerJackson2;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@JsonIgnoreProperties(ignoreUnknown=true)
@org.codehaus.jackson.annotate.JsonIgnoreProperties(ignoreUnknown=true)
@ExperimentalApi
public class RestValidationResult
implements ValidationResult {
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private final boolean authorized;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private final boolean valid;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private final boolean allowedInReadOnlyMode;
    @com.fasterxml.jackson.databind.annotation.JsonDeserialize(using=ValidationErrorDeserializerJackson2.class)
    @JsonDeserialize(using=ValidationErrorDeserializer.class)
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private final List<ValidationError> errors;

    @JsonCreator
    @org.codehaus.jackson.annotate.JsonCreator
    private RestValidationResult() {
        this(null);
    }

    public RestValidationResult(ValidationResult that) {
        if (that == null) {
            that = SimpleValidationResult.builder().build();
        }
        this.authorized = that.isAuthorized();
        this.valid = that.isValid();
        this.allowedInReadOnlyMode = that.isAllowedInReadOnlyMode();
        this.errors = Collections.unmodifiableList(new ArrayList(StreamSupport.stream(that.getErrors().spliterator(), false).map(input -> {
            if (input instanceof SimpleFieldValidationError) {
                return new RestFieldValidationError((SimpleFieldValidationError)input);
            }
            return new RestValidationError((ValidationError)input);
        }).collect(Collectors.toList())));
    }

    public boolean isAuthorized() {
        return this.authorized;
    }

    public boolean isAllowedInReadOnlyMode() {
        return this.allowedInReadOnlyMode;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Iterable<ValidationError> getErrors() {
        return this.errors;
    }

    public String toString() {
        return "RestValidationResult{ valid=" + this.valid + ", authorized=" + this.authorized + ", allowedInReadOnlyMode=" + this.allowedInReadOnlyMode + ", errors=" + this.errors + '}';
    }
}

