/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.api.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.atlassian.confluence.rest.api.model.validation.RestValidationResult;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.ws.rs.core.Response;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@com.fasterxml.jackson.annotation.JsonIgnoreProperties(ignoreUnknown=true)
@JsonIgnoreProperties(ignoreUnknown=true)
@ExperimentalApi
@RestEnrichable
public class RestError {
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private final int statusCode;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    private final RestValidationResult data;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema(example="An error occurred")
    private final String message;
    @JsonProperty
    @org.codehaus.jackson.annotate.JsonProperty
    @Schema(example="Sample Reason Phrase")
    private final String reason;

    @com.fasterxml.jackson.annotation.JsonCreator
    @JsonCreator
    private RestError() {
        this.statusCode = 0;
        this.data = null;
        this.message = null;
        this.reason = null;
    }

    RestError(Response.StatusType statusType, String message, @Nullable RestValidationResult data) {
        this(statusType.getStatusCode(), statusType.getReasonPhrase(), message, data);
    }

    RestError(int status, String message, @Nullable RestValidationResult data) {
        this(status, null, message, data);
    }

    RestError(int status, String reason, String message, @Nullable RestValidationResult data) {
        this.statusCode = status;
        this.message = message;
        this.data = data;
        this.reason = reason;
    }

    public @Nullable ValidationResult getData() {
        return this.data;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getMessage() {
        return this.message;
    }

    public String getReason() {
        return this.reason;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int statusCode;
        private RestValidationResult data;
        private String message;
        private String reason;

        public Builder statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder data(RestValidationResult data) {
            this.data = data;
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public RestError build() {
            return new RestError(this.statusCode, this.reason, this.message, this.data);
        }
    }
}

