/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rest.api.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.rest.api.services.RestNavigation;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

@ExperimentalApi
public class RestPageRequest
implements PageRequest {
    public static String START_QPARAM = "start";
    public static String LIMIT_QPARAM = "limit";
    private final int start;
    private final int limit;
    private final UriBuilder requestUri;

    public RestPageRequest(UriInfo requestInfo, int start, int limit) {
        this(RestPageRequest.getURIBuilderFromInfo(requestInfo), start, limit);
    }

    public RestPageRequest(Navigation.Builder navBuilder, int start, int limit) {
        this(RestPageRequest.asUriBuilder(navBuilder), start, limit);
    }

    private static UriBuilder getURIBuilderFromInfo(UriInfo info) {
        UriBuilder builder = UriBuilder.fromUri((URI)info.getRequestUri());
        builder = builder.replaceQueryParam("os_username", (Object[])null);
        builder = builder.replaceQueryParam("os_password", (Object[])null);
        return builder;
    }

    public RestPageRequest(UriBuilder requestUri, int start, int limit) {
        this.requestUri = requestUri;
        this.start = start;
        this.limit = limit;
    }

    public RestPageRequest(Navigation.Builder navBuilder, PageResponse<Content> pageResponse) {
        this(RestPageRequest.asUriBuilder(navBuilder), pageResponse);
    }

    private static UriBuilder asUriBuilder(Navigation.Builder navBuilder) {
        return ((RestNavigation.RestBuilder)navBuilder).toAbsoluteUriBuilder();
    }

    public RestPageRequest(UriBuilder requestUri, PageResponse response) {
        this.requestUri = requestUri;
        this.start = response.getPageRequest().getStart();
        this.limit = response.getPageRequest().getLimit();
    }

    public RestPageRequest copyWithLimits(PageResponse response) {
        PageRequest request = (PageRequest)Preconditions.checkNotNull((Object)response.getPageRequest(), (Object)"PageRequest should not be null");
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.requestUri.build(new Object[0]));
        return new RestPageRequest(uriBuilder, request.getStart(), request.getLimit());
    }

    public int getStart() {
        return this.start;
    }

    public int getLimit() {
        return this.limit;
    }

    public UriBuilder getUriBuilder() {
        return this.requestUri;
    }
}

