/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.incrementalsync.model;

import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncCursor;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SubscriptionId
implements Serializable {
    private static final long serialVersionUID = -7184032831373563572L;
    private final IncrementalSyncCursor cursor;

    private SubscriptionId(long subscriptionId, long mostRecentId) {
        this.cursor = new IncrementalSyncCursor(subscriptionId, mostRecentId);
    }

    private SubscriptionId(IncrementalSyncCursor cursor) {
        this.cursor = cursor;
    }

    public static SubscriptionId of(long subscriptionId) {
        return new SubscriptionId(subscriptionId, 0L);
    }

    public static SubscriptionId of(long subscriptionId, long mostRecentId) {
        return new SubscriptionId(subscriptionId, mostRecentId);
    }

    public static SubscriptionId of(IncrementalSyncCursor cursor) {
        Objects.requireNonNull(cursor);
        return new SubscriptionId(cursor);
    }

    @JsonProperty(value="subscriptionId")
    @Schema(example="17956865")
    public long getValue() {
        return this.cursor.getSubscriptionId();
    }

    @JsonIgnore
    public long getMostRecentId() {
        return this.cursor.getMostRecentId();
    }

    @JsonProperty(value="cursor")
    @Schema(description="Cursor is a token that could be used to get next batch of events. It's value shouldn't be parsed by recipient as it could be changed in future", example="sync:17956865:0")
    public String getCursorString() {
        return this.cursor.toString();
    }

    @JsonIgnore
    public IncrementalSyncCursor getCursor() {
        return this.cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscriptionId)) {
            return false;
        }
        SubscriptionId that = (SubscriptionId)o;
        return this.cursor.equals(that.cursor);
    }

    public int hashCode() {
        return Objects.hashCode(this.cursor);
    }

    public String toString() {
        return "Subscription Id: " + this.cursor.getSubscriptionId() + " Most recent Id: " + this.cursor.getMostRecentId();
    }
}

