/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.permissions;

import com.atlassian.confluence.api.model.permissions.SpacePermission;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.atlassian.confluence.api.serialization.jackson2.OffsetDateTimeDeserializer;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RestEnrichable
@JsonIgnoreProperties(ignoreUnknown=true)
public class SpacePermissionContainer
implements NavigationAware {
    @JsonProperty
    @Schema
    private final List<SpacePermission> data;
    @JsonIgnore
    @Schema
    private final String spaceKey;
    @JsonProperty
    @Schema(example="2024-01-01T00:00:00.000Z")
    @JsonDeserialize(using=OffsetDateTimeDeserializer.class)
    private final OffsetDateTime lastModificationDate;

    @JsonCreator
    private SpacePermissionContainer() {
        this.data = null;
        this.spaceKey = null;
        this.lastModificationDate = null;
    }

    public SpacePermissionContainer(String spaceKey, List<SpacePermission> permissions, OffsetDateTime lastModificationDate) {
        this.spaceKey = spaceKey;
        this.data = Collections.unmodifiableList(new ArrayList<SpacePermission>(permissions));
        this.lastModificationDate = lastModificationDate;
    }

    @Override
    public Navigation.Builder resolveNavigation(NavigationService navigationService) {
        return navigationService.createNavigation().spacePermission(this.spaceKey);
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public OffsetDateTime getLastModificationDate() {
        return this.lastModificationDate;
    }
}

