/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.pagination;

import com.atlassian.confluence.api.model.pagination.Cursor;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.NavigablePageResponse;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

@RestEnrichable
public class NavigablePageResponseImpl<T>
implements NavigablePageResponse<T> {
    private boolean hasMore;
    private List<T> list;
    private PageRequest request;
    private Cursor nextCursor;
    private Cursor prevCursor;
    private Optional<Long> totalCount;
    private Navigation.Builder navigationBuilder;

    protected NavigablePageResponseImpl(Builder<T, ?> builder) {
        this.hasMore = ((Builder)builder).hasMore;
        this.list = ((Builder)builder).list;
        this.request = ((Builder)builder).request;
        this.nextCursor = ((Builder)builder).nextCursor;
        this.prevCursor = ((Builder)builder).prevCursor;
        this.totalCount = ((Builder)builder).totalCount;
        this.navigationBuilder = ((Builder)builder).navigationBuilder;
    }

    @Override
    public List getResults() {
        return this.list;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean hasMore() {
        return this.hasMore;
    }

    @Override
    public PageRequest getPageRequest() {
        return this.request;
    }

    @Override
    public Optional<Long> getTotalCount() {
        return this.totalCount;
    }

    @Override
    public Cursor getNextCursor() {
        return this.nextCursor;
    }

    @Override
    public Cursor getPrevCursor() {
        return this.prevCursor;
    }

    @Override
    public Navigation.Builder getNavigationBuilder() {
        return this.navigationBuilder;
    }

    public static <T> Builder<T, ? extends Builder> from(PageResponse<T> pageResponse) {
        Builder builder = new Builder();
        builder.list = pageResponse.getResults();
        builder.request = pageResponse.getPageRequest();
        builder.nextCursor = pageResponse.getNextCursor();
        builder.prevCursor = pageResponse.getPrevCursor();
        builder.totalCount = pageResponse.getTotalCount();
        builder.hasMore = pageResponse.hasMore();
        if (pageResponse instanceof NavigablePageResponse) {
            builder.navigationBuilder = ((NavigablePageResponse)pageResponse).getNavigationBuilder();
        }
        return builder;
    }

    @Override
    public Iterator iterator() {
        return this.list.iterator();
    }

    public static class Builder<E, B> {
        private Navigation.Builder navigationBuilder;
        private boolean hasMore;
        private List<E> list = new ArrayList();
        private PageRequest request;
        private Cursor nextCursor;
        private Cursor prevCursor;
        private Optional<Long> totalCount = Optional.empty();

        public NavigablePageResponse<E> build() {
            return new NavigablePageResponseImpl(this);
        }

        public B add(E add) {
            this.list.add(add);
            return (B)this;
        }

        public B addAll(Iterable<E> toAdd) {
            toAdd.forEach(this.list::add);
            return (B)this;
        }

        public B pageRequest(PageRequest request) {
            this.request = request;
            return (B)this;
        }

        public B pageRequest(LimitedRequest limitedRequest) {
            this.request = new SimplePageRequest(limitedRequest);
            return (B)this;
        }

        public B hasMore(boolean hasMore) {
            this.hasMore = hasMore;
            return (B)this;
        }

        public B nextCursor(Cursor nextCursor) {
            this.nextCursor = nextCursor;
            return (B)this;
        }

        public B prevCursor(Cursor prevCursor) {
            this.prevCursor = prevCursor;
            return (B)this;
        }

        public B totalCount(Optional<Long> totalCount) {
            this.totalCount = totalCount;
            return (B)this;
        }

        public Builder<E, B> navigationBuilder(Navigation.Builder navigationBuilder) {
            this.navigationBuilder = navigationBuilder;
            return this;
        }

        public NavigablePageResponseImpl<E> build(List<E> results, PageRequest pageRequest, boolean hasMore) {
            return new NavigablePageResponseImpl(this);
        }
    }
}

