/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.backuprestore;

import com.atlassian.confluence.api.model.backuprestore.JobDetails;
import com.atlassian.confluence.api.model.backuprestore.JobStatistics;
import com.atlassian.confluence.api.model.backuprestore.SpaceRestoreSettings;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SpaceRestoreJobDetails
extends JobDetails {
    @JsonProperty
    private SpaceRestoreSettings jobSettings;
    @JsonProperty
    private JobStatistics statistics;

    public SpaceRestoreJobDetails() {
        super(SpaceRestoreJobDetails.builder());
    }

    private SpaceRestoreJobDetails(SpaceRestoreJobDetailsBuilder builder) {
        super(builder);
        this.jobSettings = builder.jobSettings;
        this.statistics = builder.statistics;
    }

    public SpaceRestoreSettings getJobSettings() {
        return this.jobSettings;
    }

    public JobStatistics getJobStatistics() {
        return this.statistics;
    }

    public void setJobSettings(SpaceRestoreSettings jobSettings) {
        this.jobSettings = jobSettings;
    }

    public void setJobStatistics(JobStatistics jobStatistics) {
        this.statistics = jobStatistics;
    }

    public static SpaceRestoreJobDetailsBuilder builder() {
        return new SpaceRestoreJobDetailsBuilder();
    }

    public static class SpaceRestoreJobDetailsBuilder
    extends JobDetails.JobDetailsBuilder {
        private SpaceRestoreSettings jobSettings;
        private JobStatistics statistics;

        public SpaceRestoreJobDetailsBuilder jobSettings(SpaceRestoreSettings jobSettings) {
            this.jobSettings = new SpaceRestoreSettings(jobSettings.getFileName(), jobSettings.getSkipReindex());
            return this;
        }

        public SpaceRestoreJobDetailsBuilder jobStatistics(JobStatistics jobStatistics) {
            this.statistics = new JobStatistics(jobStatistics.getTotalObjectsCount(), jobStatistics.getProcessedObjectsCount(), jobStatistics.getPersistedObjectsCount(), jobStatistics.getSkippedObjectsCount(), jobStatistics.getReusedObjectsCount());
            return this;
        }

        @Override
        public SpaceRestoreJobDetails build() {
            return new SpaceRestoreJobDetails(this);
        }
    }
}

