/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model;

import com.atlassian.confluence.api.model.Expansions;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

public class Expansion {
    private final String propertyName;
    private final Expansions subExpansions;

    public Expansion(String propertyName) {
        this(propertyName, Expansions.EMPTY);
    }

    public Expansion(String propertyName, Expansions subExpansions) {
        this.propertyName = propertyName;
        this.subExpansions = subExpansions;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Expansions getSubExpansions() {
        return this.subExpansions;
    }

    public static Expansion combine(Object ... expansionParts) {
        String joinedString = Arrays.stream(expansionParts).map(Object::toString).collect(Collectors.joining("."));
        return new Expansion(joinedString);
    }

    public String toString() {
        return "Expansion{propertyName='" + this.propertyName + '\'' + ", subExpansions=" + this.subExpansions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expansion expansion = (Expansion)o;
        return Objects.equals(this.propertyName, expansion.propertyName) && Objects.equals(this.subExpansions, expansion.subExpansions);
    }

    public int hashCode() {
        return Objects.hash(this.propertyName, this.subExpansions);
    }
}

