/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

public class OffsetDateTimeDeserializer
extends JsonDeserializer<OffsetDateTime> {
    public OffsetDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        String dateString = jp.getText();
        if (StringUtils.isNumeric((CharSequence)dateString)) {
            return OffsetDateTime.ofInstant(Instant.ofEpochSecond(Long.parseLong(dateString)), ZoneId.systemDefault());
        }
        if (this.isUnixTimestampWithDecimal(dateString)) {
            double timestamp = Double.parseDouble(dateString);
            long seconds = (long)timestamp;
            int nanos = (int)((timestamp - (double)seconds) * 1.0E9);
            return OffsetDateTime.ofInstant(Instant.ofEpochSecond(seconds, nanos), ZoneId.systemDefault());
        }
        return OffsetDateTime.parse(dateString, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public boolean isUnixTimestampWithDecimal(String dateString) {
        return dateString.matches("\\d+\\.\\d+");
    }
}

