/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.search.autocomplete;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AutocompleteResultItem {
    @JsonProperty
    private final String id;
    @JsonProperty
    private final String text;

    @JsonCreator
    private AutocompleteResultItem() {
        this(AutocompleteResultItem.builder());
    }

    private AutocompleteResultItem(Builder builder) {
        this.id = builder.id;
        this.text = builder.text;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AutocompleteResultItem)) {
            return false;
        }
        AutocompleteResultItem autocompleteResultItem = (AutocompleteResultItem)other;
        return Objects.equals(autocompleteResultItem.id, this.id) && Objects.equals(autocompleteResultItem.text, this.text);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.text);
    }

    public static class Builder {
        private String id;
        private String text;

        private Builder() {
        }

        public AutocompleteResultItem build() {
            return new AutocompleteResultItem(this);
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }
    }
}

