/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.people;

import com.atlassian.confluence.api.model.people.Subject;
import com.atlassian.confluence.api.model.people.SubjectType;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.atlassian.confluence.api.serialization.RestEnrichableProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@RestEnrichable
public class Group
implements Subject,
NavigationAware {
    protected static final String GROUP_TYPE = "group";
    @RestEnrichableProperty
    @JsonIgnore
    private final String type = "group";
    @JsonProperty
    @Schema(example="group1")
    private final String name;

    @JsonCreator
    public Group(@JsonProperty(value="name") String name) {
        this.name = Objects.requireNonNull(name).toLowerCase();
    }

    @Schema(example="group1")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonIgnore
    public String getDisplayName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        String otherName = ((Group)other).name;
        return this.name.equals(otherName);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "Group[" + this.name + "]";
    }

    @Override
    public Navigation.Builder resolveNavigation(NavigationService navigationService) {
        return navigationService.createNavigation().group(this);
    }

    @Override
    @JsonIgnore
    public SubjectType getSubjectType() {
        return SubjectType.GROUP;
    }

    public static GroupBuilder builder() {
        return new GroupBuilder();
    }

    public static class GroupBuilder {
        private String name;

        public GroupBuilder name(String name) {
            this.name = name;
            return this;
        }

        public Group build() {
            return new Group(this.name);
        }
    }
}

