/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.backuprestore;

import com.atlassian.confluence.api.model.backuprestore.JobDetails;
import com.atlassian.confluence.api.model.backuprestore.JobStatistics;
import com.atlassian.confluence.api.model.backuprestore.SiteRestoreSettings;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SiteRestoreJobDetails
extends JobDetails {
    @JsonProperty
    private SiteRestoreSettings jobSettings;
    @JsonProperty
    private JobStatistics statistics;

    public SiteRestoreJobDetails() {
        super(SiteRestoreJobDetails.builder());
    }

    private SiteRestoreJobDetails(SiteRestoreJobDetailsBuilder builder) {
        super(builder);
        this.jobSettings = builder.jobSettings;
        this.statistics = builder.statistics;
    }

    public SiteRestoreSettings getJobSettings() {
        return this.jobSettings;
    }

    public JobStatistics getJobStatistics() {
        return this.statistics;
    }

    public void setJobSettings(SiteRestoreSettings jobSettings) {
        this.jobSettings = jobSettings;
    }

    public void setJobStatistics(JobStatistics jobStatistics) {
        this.statistics = jobStatistics;
    }

    public static SiteRestoreJobDetailsBuilder builder() {
        return new SiteRestoreJobDetailsBuilder();
    }

    public static class SiteRestoreJobDetailsBuilder
    extends JobDetails.JobDetailsBuilder {
        private SiteRestoreSettings jobSettings;
        private JobStatistics statistics;

        public SiteRestoreJobDetailsBuilder jobSettings(SiteRestoreSettings jobSettings) {
            this.jobSettings = new SiteRestoreSettings(jobSettings.getFileName(), jobSettings.getSkipReindex());
            return this;
        }

        public SiteRestoreJobDetailsBuilder jobStatistics(JobStatistics jobStatistics) {
            this.statistics = new JobStatistics(jobStatistics.getTotalObjectsCount(), jobStatistics.getProcessedObjectsCount(), jobStatistics.getPersistedObjectsCount(), jobStatistics.getSkippedObjectsCount(), jobStatistics.getReusedObjectsCount());
            return this;
        }

        @Override
        public SiteRestoreJobDetails build() {
            return new SiteRestoreJobDetails(this);
        }
    }
}

