/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.Expansions;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import java.util.Objects;

@ExperimentalApi
public class Expansion {
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private final String propertyName;
    private final Expansions subExpansions;
    public static final Function<String, Expansion> AS_EXPANSION = Expansion::new;

    public Expansion(String propertyName) {
        this(propertyName, Expansions.EMPTY);
    }

    public Expansion(String propertyName, Expansions subExpansions) {
        this.propertyName = propertyName;
        this.subExpansions = subExpansions;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Expansions getSubExpansions() {
        return this.subExpansions;
    }

    public static Expansion combine(Object ... expansionParts) {
        return new Expansion(DOT_JOINER.join(expansionParts));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.propertyName).add("subExpansions", (Object)this.subExpansions).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Expansion expansion = (Expansion)o;
        return Objects.equals(this.propertyName, expansion.propertyName) && Objects.equals(this.subExpansions, expansion.subExpansions);
    }

    public int hashCode() {
        return Objects.hash(this.propertyName, this.subExpansions);
    }
}

