/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.permissions.spi;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.permissions.Target;
import com.atlassian.confluence.api.model.permissions.TargetType;
import com.atlassian.confluence.api.model.permissions.spi.OperationCheck;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.fugue.Option;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.stream.StreamSupport;
import org.checkerframework.checker.nullness.qual.NonNull;

@ExperimentalSpi
public abstract class BaseOperationCheck
implements OperationCheck {
    private final OperationKey operationKey;
    private final TargetType expectedTargetType;

    protected BaseOperationCheck(OperationKey operationKey, TargetType expectedTargetType) {
        this.operationKey = (OperationKey)Preconditions.checkNotNull((Object)operationKey);
        this.expectedTargetType = (TargetType)Preconditions.checkNotNull((Object)expectedTargetType);
    }

    @Override
    public final @NonNull OperationKey getOperationKey() {
        return this.operationKey;
    }

    @Override
    public final @NonNull ValidationResult canPerform(Person person, Target target) {
        Map<Target, ValidationResult> map = this.canPerform(person, (Iterable<Target>)Option.some((Object)target));
        ValidationResult result = map.get(target);
        Preconditions.checkState((result != null && map.size() == 1 ? 1 : 0) != 0, (String)"OperationCheck subclass returned unexpected map contents for singleton canPerform: %s", map);
        return result;
    }

    @Override
    public final @NonNull ValidationResult canPerformAccordingToState(Person person, Target target) {
        Map<Target, ValidationResult> map = this.canPerformAccordingToState(person, (Iterable<Target>)Option.some((Object)target));
        ValidationResult result = map.get(target);
        Preconditions.checkState((result != null && map.size() == 1 ? 1 : 0) != 0, (String)"OperationCheck subclass returned unexpected map contents for singleton canPerform: %s", map);
        return result;
    }

    @Override
    public final @NonNull Map<Target, ValidationResult> canPerform(Person person, Iterable<Target> targets) {
        this.validateCanPerformParams(person, targets);
        for (Target target : targets) {
            Preconditions.checkNotNull((Object)target);
            Preconditions.checkArgument((boolean)this.expectedTargetType.equals(target.getTargetType()), (String)"Unsupported TargetType '%s' for operation '%s' on target: %s", (Object)target.getTargetType(), (Object)this.getOperationKey(), (Object)target);
        }
        return this.canPerformImpl(person, targets);
    }

    @Override
    public final @NonNull Map<Target, ValidationResult> canPerformAccordingToState(Person person, Iterable<Target> targets) {
        this.validateCanPerformParams(person, targets);
        for (Target target : targets) {
            Preconditions.checkNotNull((Object)target);
            Preconditions.checkArgument((boolean)this.expectedTargetType.equals(target.getTargetType()), (String)"Unsupported TargetType '%s' for operation '%s' on target: %s", (Object)target.getTargetType(), (Object)this.getOperationKey(), (Object)target);
        }
        return this.canPerformAccordingToStateImpl(person, targets);
    }

    private void validateCanPerformParams(Person person, Iterable<Target> targets) {
        Preconditions.checkNotNull((Object)person);
        Preconditions.checkNotNull(targets);
        Target firstTarget = (Target)Iterables.getFirst(targets, null);
        Preconditions.checkArgument((firstTarget != null ? 1 : 0) != 0, (Object)"At least one target must be supplied");
        boolean isAllTargetHaveSameClass = StreamSupport.stream(targets.spliterator(), false).allMatch(target -> firstTarget.getClass().equals(target.getClass()));
        Preconditions.checkArgument((boolean)isAllTargetHaveSameClass, (Object)"All targets must belong to the same concrete Target class");
    }

    protected abstract @NonNull Map<Target, ValidationResult> canPerformImpl(@NonNull Person var1, @NonNull Iterable<Target> var2);

    protected abstract @NonNull Map<Target, ValidationResult> canPerformAccordingToStateImpl(@NonNull Person var1, @NonNull Iterable<Target> var2);
}

