/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.validation;

import com.atlassian.confluence.api.model.messages.Message;
import com.atlassian.confluence.api.model.validation.SimpleFieldValidationError;
import com.atlassian.confluence.api.model.validation.SimpleValidationError;
import com.atlassian.confluence.api.model.validation.ValidationError;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.fugue.Function2;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

public class SimpleValidationResult
implements ValidationResult {
    private static final Function2<String, ValidationResult, ServiceException> defaultSupplier = (message, validationResult) -> {
        if (!validationResult.isAuthorized()) {
            return new PermissionException((String)message, (ValidationResult)validationResult);
        }
        return new BadRequestException((String)message, (ValidationResult)validationResult);
    };
    public static final ValidationResult VALID = new Builder().authorized(true).build();
    public static final ValidationResult FORBIDDEN = new Builder().authorized(false).build();
    private final boolean authorized;
    private final List<ValidationError> errors;
    private final Function2<String, ValidationResult, ? extends ServiceException> exceptionSupplier;

    private SimpleValidationResult(Builder builder) {
        this.authorized = builder.authorized;
        this.errors = builder.errors.build();
        this.exceptionSupplier = builder.exceptionSupplier != null ? builder.exceptionSupplier : defaultSupplier;
    }

    @Override
    public boolean isAuthorized() {
        return this.authorized;
    }

    public Collection<ValidationError> getErrors() {
        return this.errors;
    }

    @Override
    public ServiceException convertToServiceException(String errorMsg) {
        throw (ServiceException)this.exceptionSupplier.apply((Object)errorMsg, (Object)this);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("authorized", this.authorized).add("errors", this.errors).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean authorized;
        private ImmutableList.Builder<ValidationError> errors = ImmutableList.builder();
        private Function2<String, ValidationResult, ? extends ServiceException> exceptionSupplier;

        public Builder authorized(boolean value) {
            this.authorized = value;
            return this;
        }

        public Builder addFieldError(String fieldName, String key, Object ... args) {
            return this.addError(new SimpleFieldValidationError(fieldName, key, args));
        }

        public Builder addMessage(Message message) {
            return this.addError(new SimpleValidationError(message));
        }

        public Builder addError(String key, Object ... args) {
            return this.addError(new SimpleValidationError(key, args));
        }

        public Builder addError(ValidationError error) {
            this.errors.add((Object)error);
            return this;
        }

        public Builder addErrors(List<ValidationError> errors) {
            this.errors.addAll(errors);
            return this;
        }

        @Deprecated
        public Builder addExceptionSupplier(Function<String, ? extends ServiceException> exceptionSupplier) {
            this.exceptionSupplier = exceptionSupplier == null ? null : new LegacyExceptionSupplierWrapper(exceptionSupplier);
            return this;
        }

        public Builder addExceptionSupplier(Function2<String, ValidationResult, ? extends ServiceException> exceptionSupplier) {
            this.exceptionSupplier = exceptionSupplier;
            return this;
        }

        public ValidationResult build() {
            return new SimpleValidationResult(this);
        }

        public boolean hasErrors() {
            return !this.errors.build().isEmpty();
        }
    }

    private static class LegacyExceptionSupplierWrapper
    implements Function2<String, ValidationResult, ServiceException> {
        private final Function<String, ? extends ServiceException> delegate;

        public LegacyExceptionSupplierWrapper(Function<String, ? extends ServiceException> delegate) {
            this.delegate = delegate;
        }

        public ServiceException apply(String message, ValidationResult validationResult) {
            return (ServiceException)this.delegate.apply((Object)message);
        }
    }
}

