/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.service.exceptions;

import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;

public class InvalidRepresentationException
extends RuntimeException {
    private final ContentRepresentation[] permittedRepresentations;

    public InvalidRepresentationException(ContentRepresentation unacceptableRepresentation, ContentRepresentation[] permittedRepresentations) {
        super("Unacceptable content representation : " + unacceptableRepresentation + ". Allowed representations: " + Arrays.toString(permittedRepresentations));
        this.permittedRepresentations = permittedRepresentations;
    }

    public InvalidRepresentationException(ContentRepresentation representation, Iterable<ContentRepresentation> contentRepresentations) {
        this(representation, (ContentRepresentation[])Iterables.toArray(contentRepresentations, ContentRepresentation.class));
    }

    public Iterable<ContentRepresentation> getPermittedRepresentations() {
        return Collections.unmodifiableCollection(Arrays.asList(this.permittedRepresentations));
    }
}

