/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.permissions;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.people.Subject;
import com.atlassian.confluence.api.model.people.SubjectType;
import com.atlassian.confluence.api.model.permissions.OperationKey;
import com.atlassian.confluence.api.model.reference.BuilderUtils;
import com.atlassian.confluence.api.model.reference.ExpandedReference;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@ExperimentalApi
@RestEnrichable
@JsonIgnoreProperties(ignoreUnknown=true)
public class ContentRestriction
implements NavigationAware {
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Content.class)
    @JsonProperty
    private final Reference<Content> content;
    @JsonProperty
    private final OperationKey operation;
    @JsonDeserialize(contentAs=PageResponseImpl.class)
    @JsonProperty
    private final Map<SubjectType, PageResponse<Subject>> restrictions;

    @JsonCreator
    private ContentRestriction() {
        this(ContentRestriction.builder());
    }

    private ContentRestriction(ContentRestrictionBuilder builder) {
        this.content = builder.content;
        this.operation = builder.operation;
        this.restrictions = BuilderUtils.modelMap(builder.restrictions);
    }

    public static ContentRestrictionBuilder builder() {
        return new ContentRestrictionBuilder();
    }

    public static ContentRestrictionBuilder builder(ContentRestriction restriction) {
        return new ContentRestrictionBuilder(restriction);
    }

    public Reference<Content> getContent() {
        return this.content;
    }

    public OperationKey getOperation() {
        return this.operation;
    }

    public Map<SubjectType, PageResponse<Subject>> getRestrictions() {
        return this.restrictions;
    }

    @Override
    public Navigation.Builder resolveNavigation(NavigationService navigationService) {
        return navigationService.createNavigation().content(this.content).restrictionByOperation().operation(this.operation);
    }

    public static class Expansions {
        public static final String CONTENT = "content";
        public static final String RESTRICTIONS = "restrictions";
    }

    public static class ContentRestrictionBuilder {
        private Reference<Content> content = Reference.collapsed(Content.class);
        private OperationKey operation;
        private Map<SubjectType, PageResponse<Subject>> restrictions;

        private ContentRestrictionBuilder() {
        }

        private ContentRestrictionBuilder(ContentRestriction restriction) {
            this.content(restriction.getContent());
            this.operation(restriction.getOperation());
            this.restrictions(restriction.getRestrictions());
        }

        public ContentRestrictionBuilder content(Reference<Content> content) {
            this.content = content;
            return this;
        }

        public ContentRestrictionBuilder operation(OperationKey operation) {
            this.operation = operation;
            return this;
        }

        public ContentRestrictionBuilder restrictions(Map<SubjectType, PageResponse<Subject>> restrictions) {
            this.restrictions = restrictions;
            return this;
        }

        public ContentRestriction build() {
            return new ContentRestriction(this);
        }
    }
}

