/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.journal;

import com.atlassian.annotations.PublicApi;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.regex.Pattern;

@PublicApi
public class JournalIdentifier
implements Serializable {
    private static final Pattern JOURNAL_NAME_PATTERN = Pattern.compile("[a-z0-9_\\.]{1,255}");
    private final String journalName;

    public JournalIdentifier(String journalName) {
        Preconditions.checkArgument((boolean)JOURNAL_NAME_PATTERN.matcher(journalName).matches(), (Object)("journal name must match the following regular expression: " + JOURNAL_NAME_PATTERN.pattern()));
        this.journalName = journalName;
    }

    public String getJournalName() {
        return this.journalName;
    }

    public boolean equals(Object o) {
        if (o instanceof JournalIdentifier) {
            return Objects.equal((Object)this.journalName, (Object)((JournalIdentifier)o).journalName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.journalName});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("journalName", (Object)this.journalName).toString();
    }
}

