/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.Container;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.FormattedBody;
import com.atlassian.confluence.api.model.content.SpaceType;
import com.atlassian.confluence.api.model.reference.BuilderUtils;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.model.reference.ExpandedReference;
import com.atlassian.confluence.api.model.reference.ModelMapBuilder;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@ExperimentalApi
@RestEnrichable
@JsonIgnoreProperties(ignoreUnknown=true)
public class Space
implements Container,
NavigationAware {
    @JsonProperty
    private final Long id;
    @JsonProperty
    private final String key;
    @JsonProperty
    private final String name;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Icon.class)
    @JsonProperty
    private final Reference<Icon> icon;
    @JsonDeserialize(as=EnrichableMap.class)
    @JsonProperty
    private final Map<ContentRepresentation, FormattedBody> description;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Content.class)
    @JsonProperty
    private final Reference<Content> homepage;
    @JsonProperty
    private final SpaceType type;

    public static String getSpaceKey(Reference<Space> reference) {
        return (String)reference.getIdProperty(IdProperties.key);
    }

    public static Reference<Space> buildReference(String spaceKey) {
        return Reference.collapsed(Space.class, (Map)ImmutableMap.of((Object)((Object)IdProperties.key), (Object)spaceKey));
    }

    public static SpaceBuilder builder() {
        return new SpaceBuilder();
    }

    public static SpaceBuilder builder(Space space) {
        return Space.builder().name(space.name).key(space.key).id(space.getId()).icon(space.icon).description(space.description).homepage(space.homepage).type(space.type);
    }

    private Space(SpaceBuilder builder) {
        this.name = builder.name;
        this.key = builder.key;
        this.id = builder.id;
        this.icon = Reference.orEmpty(builder.icon, Icon.class);
        this.description = BuilderUtils.modelMap(builder.description);
        this.homepage = Reference.orEmpty(builder.homepage, Content.class);
        this.type = builder.type;
    }

    @JsonCreator
    private Space() {
        this(Space.builder());
    }

    public long getId() {
        if (this.id == null) {
            return 0L;
        }
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    @JsonIgnore
    public Reference<Icon> getIconRef() {
        return Reference.orEmpty(this.icon, Icon.class);
    }

    public Map<ContentRepresentation, FormattedBody> getDescription() {
        return this.description;
    }

    @Deprecated
    @JsonIgnore
    public Map<ContentRepresentation, Reference<FormattedBody>> getDescriptionRefs() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<ContentRepresentation, FormattedBody> entry : this.description.entrySet()) {
            builder.put((Object)entry.getKey(), Reference.to(entry.getValue()));
        }
        if (this.description instanceof EnrichableMap) {
            EnrichableMap enrichableMap = (EnrichableMap)this.description;
            for (ContentRepresentation representation : enrichableMap.getCollapsedEntries()) {
                Reference<FormattedBody> collapsed = Reference.collapsed(FormattedBody.class);
                builder.put((Object)representation, collapsed);
            }
        }
        return builder.build();
    }

    @JsonIgnore
    public Reference<Content> getHomepageRef() {
        return Reference.orEmpty(this.homepage, Content.class);
    }

    public SpaceType getType() {
        return this.type;
    }

    @Override
    public Navigation.Builder resolveNavigation(NavigationService navigationService) {
        return navigationService.createNavigation().space(this);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("key", (Object)this.key).add("name", (Object)this.name).toString();
    }

    public static class Expansions {
        public static final String DESCRIPTION = "description";
        public static final String HOMEPAGE = "homepage";
        public static final String ICON = "icon";
    }

    public static class SpaceBuilder {
        private Long id = null;
        private String key = null;
        private String name = null;
        private Reference<Icon> icon = null;
        private ModelMapBuilder<ContentRepresentation, FormattedBody> description = ModelMapBuilder.newInstance();
        private Reference<Content> homepage = null;
        private SpaceType type = SpaceType.GLOBAL;

        private SpaceBuilder() {
        }

        public Space build() {
            return new Space(this);
        }

        public SpaceBuilder description(ContentRepresentation representation, String value) {
            return this.description(representation, new FormattedBody(representation, value));
        }

        public SpaceBuilder description(ContentRepresentation representation, FormattedBody formattedBody) {
            this.description.put(representation, formattedBody);
            return this;
        }

        public SpaceBuilder description(Map<ContentRepresentation, FormattedBody> description) {
            this.description.copy(description);
            return this;
        }

        @Deprecated
        public SpaceBuilder description(ContentRepresentation representation, Reference<FormattedBody> formattedBody) {
            if (formattedBody.isExpanded()) {
                this.description(representation, formattedBody.get());
            }
            return this;
        }

        public SpaceBuilder icon(Icon icon) {
            this.icon = Reference.orEmpty(icon, Icon.class);
            return this;
        }

        public SpaceBuilder icon(Reference<Icon> iconRef) {
            this.icon = iconRef;
            return this;
        }

        public SpaceBuilder id(long id) {
            this.id = id;
            return this;
        }

        public SpaceBuilder key(String key) {
            this.key = key;
            return this;
        }

        public SpaceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SpaceBuilder homepage(Reference<Content> homepageRef) {
            this.homepage = homepageRef;
            return this;
        }

        public SpaceBuilder homepage(Content homepage) {
            this.homepage = Reference.to(homepage);
            return this;
        }

        public SpaceBuilder type(SpaceType type) {
            this.type = type;
            return this;
        }
    }

    static enum IdProperties {
        key;

    }
}

