/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.JsonString;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.JsonContentPropertyId;
import com.atlassian.confluence.api.model.reference.ExpandedReference;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import javax.annotation.Nullable;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
@RestEnrichable
public class JsonContentProperty
implements NavigationAware {
    @JsonProperty
    private final JsonContentPropertyId id;
    @JsonProperty
    private final String key;
    @JsonProperty
    private final JsonString value;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Content.class)
    @JsonProperty
    private final Reference<Content> content;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Version.class)
    @JsonProperty
    private final Reference<Version> version;

    @JsonCreator
    private JsonContentProperty() {
        this(JsonContentProperty.builder());
    }

    private JsonContentProperty(ContentPropertyBuilder builder) {
        this.id = builder.id;
        this.key = builder.key;
        this.content = Reference.orEmpty(builder.content, Content.class);
        this.version = builder.version;
        this.value = builder.value;
    }

    public static ContentPropertyBuilder builder() {
        return new ContentPropertyBuilder();
    }

    public static ContentPropertyBuilder builder(JsonContentProperty propertyTemplate) {
        return JsonContentProperty.builder().id(propertyTemplate.id).key(propertyTemplate.key).content(propertyTemplate.content).version(propertyTemplate.version).value(propertyTemplate.value);
    }

    public static Reference<JsonContentProperty> buildReference(@Nullable JsonContentPropertyId id) {
        if (id == null) {
            return Reference.empty(JsonContentProperty.class);
        }
        return Reference.collapsed(JsonContentProperty.builder().id(id).build());
    }

    public JsonContentPropertyId getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public JsonString getValue() {
        return this.value;
    }

    public Reference<Content> getContentRef() {
        return this.content;
    }

    public Content getContent() {
        return this.getContentRef().get();
    }

    @Nullable
    public Version getVersion() {
        return this.version != null ? this.version.get() : null;
    }

    @Override
    public Navigation.Builder resolveNavigation(NavigationService navigationService) {
        return this.content.exists() ? navigationService.createNavigation().content(this.content).property(this) : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonContentProperty that = (JsonContentProperty)o;
        if (!this.content.equals(that.content)) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.content != null ? this.content.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JsonContentProperty{id='" + this.id + '\'' + ", key='" + this.key + '\'' + ", content=" + this.content + ", version=" + this.version + '}';
    }

    public static class Expansions {
        public static final String CONTENT = "content";
        public static final String VERSION = "version";
    }

    private static enum IdProperties {
        content,
        key;

    }

    public static class ContentPropertyBuilder {
        private JsonContentPropertyId id;
        private String key;
        private Reference<Content> content;
        private Reference<Version> version = null;
        private JsonString value;

        public JsonContentProperty build() {
            return new JsonContentProperty(this);
        }

        public ContentPropertyBuilder id(JsonContentPropertyId id) {
            this.id = id;
            return this;
        }

        public ContentPropertyBuilder key(String key) {
            this.key = key;
            return this;
        }

        public ContentPropertyBuilder content(Content content) {
            this.content = Reference.to(content);
            return this;
        }

        public ContentPropertyBuilder content(Reference<Content> contentRef) {
            this.content = contentRef;
            return this;
        }

        public ContentPropertyBuilder version(Version version) {
            this.version = Reference.to(version);
            return this;
        }

        public ContentPropertyBuilder version(Reference<Version> version) {
            this.version = version;
            return this;
        }

        public ContentPropertyBuilder value(JsonString value) {
            this.value = value;
            return this;
        }
    }
}

