/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.BaseApiEnum;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;

@ExperimentalApi
public final class ContentType
extends BaseApiEnum {
    public static final ContentType PAGE = new ContentType("page");
    public static final ContentType BLOG_POST = new ContentType("blogpost");
    public static final ContentType COMMENT = new ContentType("comment");
    public static final ContentType ATTACHMENT = new ContentType("attachment");
    public static final List<ContentType> BUILT_IN = ImmutableList.of((Object)PAGE, (Object)BLOG_POST, (Object)COMMENT, (Object)ATTACHMENT);

    @JsonCreator
    public static ContentType valueOf(String type) {
        for (ContentType contentType : BUILT_IN) {
            if (!type.equals(contentType.getType())) continue;
            return contentType;
        }
        return new ContentType(type);
    }

    public static Set<ContentType> valuesOf(Iterable<String> types) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String type : types) {
            builder.add((Object)ContentType.valueOf(type));
        }
        return builder.build();
    }

    @JsonIgnore
    private ContentType(String type) {
        super(type);
    }

    public String getType() {
        return this.serialise();
    }
}

