/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.web;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.web.Icon;
import com.atlassian.soy.renderer.CustomSoyDataMapper;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonProperty;

@ExperimentalApi
@CustomSoyDataMapper(value="jackson2soy")
public class WebItemView {
    @JsonProperty
    private final String url;
    @JsonProperty
    private final String label;
    @JsonProperty
    private final int weight;
    @JsonProperty
    private String key;
    @JsonProperty
    private String id;
    @JsonProperty
    private String accessKey;
    @JsonProperty
    private String tooltip;
    @JsonProperty
    private String styleClass;
    @JsonProperty
    private Icon icon;
    @JsonProperty
    private String urlWithoutContextPath;
    @JsonProperty
    private Map<String, String> params;

    private WebItemView(String key, String url, String label, int weight, String urlWithoutContextPath) {
        this.key = key;
        this.url = url;
        this.label = label;
        this.weight = weight;
        this.urlWithoutContextPath = urlWithoutContextPath;
    }

    public String getLinkUrl() {
        return this.url;
    }

    public String getId() {
        return this.id;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getLabel() {
        return this.label;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getWeight() {
        return this.weight;
    }

    public String getKey() {
        return this.key;
    }

    public String getUrlWithoutContextPath() {
        return this.urlWithoutContextPath;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public static class Builder {
        private String key;
        private String id;
        private String accessKey;
        private String tooltip;
        private String styleClass;
        private Icon icon;
        private String urlWithoutContextPath;
        private Map<String, String> params;

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setAccessKey(String accessKey) {
            this.accessKey = accessKey;
            return this;
        }

        public Builder setTooltip(String tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder setStyleClass(String styleClass) {
            this.styleClass = styleClass;
            return this;
        }

        public Builder setIcon(Icon icon) {
            this.icon = icon;
            return this;
        }

        public Builder setUrlWithoutContextPath(String urlWithoutContextPath) {
            this.urlWithoutContextPath = urlWithoutContextPath;
            return this;
        }

        public Builder setParams(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public WebItemView create(String key, String url, String label, int weight) {
            WebItemView link = new WebItemView(key, url, label, weight, this.urlWithoutContextPath);
            link.id = this.id;
            link.accessKey = this.accessKey;
            link.tooltip = this.tooltip;
            link.styleClass = this.styleClass;
            link.icon = this.icon;
            link.params = this.params;
            return link;
        }
    }
}

