/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.search;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.fugue.Option;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchContext {
    public static final SearchContext EMPTY = SearchContext.builder().build();
    @JsonProperty
    private final String spaceKey;
    @JsonProperty
    private final ContentId contentId;

    @JsonCreator
    private SearchContext() {
        this(SearchContext.builder());
    }

    private SearchContext(Builder builder) {
        this.spaceKey = builder.spaceKey;
        this.contentId = builder.contentId;
    }

    public Option<ContentId> getContentId() {
        return Option.option((Object)this.contentId);
    }

    public Option<String> getSpaceKey() {
        return Option.option((Object)this.spaceKey);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String spaceKey;
        private ContentId contentId;

        private Builder() {
        }

        public Builder spaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
            return this;
        }

        public Builder contentId(ContentId contentId) {
            this.contentId = contentId;
            return this;
        }

        public SearchContext build() {
            return new SearchContext(this);
        }
    }
}

