/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.locator;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.locator.ContentLocatorBuilder;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.joda.time.LocalDate;

@ExperimentalApi
public final class ContentLocator {
    @JsonProperty
    private final String title;
    @JsonProperty
    private final String spaceKey;
    @JsonProperty
    private final LocalDate postingDay;
    @JsonProperty
    private final ContentType[] contentTypes;

    public static ContentLocatorBuilder builder() {
        return new ContentLocatorBuilder();
    }

    @JsonCreator
    private ContentLocator() {
        this.title = null;
        this.spaceKey = null;
        this.postingDay = null;
        this.contentTypes = null;
    }

    ContentLocator(String title, String spaceKey, LocalDate postingDay, ContentType ... contentTypes) {
        this.title = title;
        this.spaceKey = spaceKey;
        this.postingDay = postingDay;
        this.contentTypes = contentTypes;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public LocalDate getPostingDay() {
        return this.postingDay;
    }

    public ContentType[] getContentTypes() {
        return this.contentTypes;
    }

    public boolean isForContent(ContentType contentType) {
        return this.contentTypes.length == 1 && this.contentTypes[0].equals(contentType);
    }
}

