/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.content;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.Container;
import com.atlassian.confluence.api.model.content.ContainerMap;
import com.atlassian.confluence.api.model.content.ContentBody;
import com.atlassian.confluence.api.model.content.ContentRepresentation;
import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.History;
import com.atlassian.confluence.api.model.content.InternalDeserializers;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.link.Link;
import com.atlassian.confluence.api.model.link.LinkType;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.reference.BuilderUtils;
import com.atlassian.confluence.api.model.reference.EnrichableMap;
import com.atlassian.confluence.api.model.reference.ExpandedReference;
import com.atlassian.confluence.api.model.reference.ModelMapBuilder;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.nav.Navigation;
import com.atlassian.confluence.api.nav.NavigationAware;
import com.atlassian.confluence.api.nav.NavigationService;
import com.atlassian.confluence.api.serialization.RestEnrichable;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonDeserialize;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
@RestEnrichable
public class Content
implements Container,
NavigationAware {
    @JsonProperty
    private final ContentId id;
    @JsonProperty
    private final ContentType type;
    @JsonProperty
    private final ContentStatus status;
    @JsonProperty
    private final String title;
    @JsonProperty
    private final Map<LinkType, Link> links;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Space.class)
    @JsonProperty
    private final Reference<Space> space;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=History.class)
    @JsonProperty
    private final Reference<History> history;
    @JsonDeserialize(as=ExpandedReference.class, contentAs=Version.class)
    @JsonProperty
    private final Reference<Version> version;
    @JsonProperty
    private final List<Content> ancestors;
    @JsonDeserialize(contentAs=PageResponseImpl.class)
    @JsonProperty
    private final Map<ContentType, PageResponse<Content>> children;
    @JsonDeserialize(contentAs=PageResponseImpl.class)
    @JsonProperty
    private final Map<ContentType, PageResponse<Content>> descendants;
    @JsonDeserialize(using=InternalDeserializers.ContainerMapDeserializer.class)
    @JsonProperty
    private final Container container;
    @JsonDeserialize(as=EnrichableMap.class)
    @JsonProperty
    private final Map<ContentRepresentation, ContentBody> body;
    @JsonDeserialize(as=EnrichableMap.class)
    @JsonProperty
    private final Map<String, Object> metadata;
    @JsonDeserialize(as=EnrichableMap.class)
    @JsonProperty
    private final Map<String, Object> extensions;

    public static ContentId getContentId(Reference<Content> contentRef) {
        return (ContentId)contentRef.getIdProperty(IdProperties.id);
    }

    public static ContentBuilder builder() {
        return new ContentBuilder();
    }

    public static ContentBuilder builder(ContentType type) {
        return new ContentBuilder(type);
    }

    public static ContentBuilder builder(ContentType type, long id) {
        return new ContentBuilder(type, id);
    }

    public static ContentBuilder builder(Content content) {
        return new ContentBuilder(content.type).id(content.id).status(content.status).title(content.title).version(content.version).space(content.space).ancestors(content.ancestors).children(content.children).descendants(content.descendants).body(content.body).container(content.container).history(content.history).metadata(content.metadata).extensions(content.extensions);
    }

    public static Reference<Content> buildReference(ContentId id) {
        if (id == null) {
            return Reference.empty(Content.class);
        }
        return Reference.collapsed(Content.builder().id(id).build());
    }

    @JsonCreator
    private Content() {
        this(Content.builder());
    }

    private Content(ContentBuilder builder) {
        this.id = builder.id;
        this.status = builder.status;
        this.space = Reference.orEmpty(builder.space, Space.class);
        this.type = builder.type;
        this.title = builder.title;
        this.links = builder.links.build();
        this.history = Reference.orEmpty(builder.history, History.class);
        this.container = builder.container != null ? builder.container : new ContainerMap.CollapsedContainer();
        this.ancestors = BuilderUtils.immutableListOrCollapsed(builder.ancestors);
        this.children = BuilderUtils.modelMap(builder.children);
        this.descendants = BuilderUtils.modelMap(builder.descendants);
        this.body = BuilderUtils.modelMap(builder.bodyMapBuilder);
        this.metadata = BuilderUtils.modelMap(builder.metadata);
        this.extensions = BuilderUtils.modelMap(builder.extensions);
        this.version = builder.version;
    }

    public ContentId getId() {
        return this.id;
    }

    public ContentStatus getStatus() {
        return this.status;
    }

    public ContentType getType() {
        return this.type;
    }

    public String getTitle() {
        return this.title;
    }

    @JsonIgnore
    public Map<LinkType, Link> getLinks() {
        return this.links;
    }

    public Reference<History> getHistoryRef() {
        if (this.history == null) {
            return Reference.empty(History.class);
        }
        return this.history;
    }

    public History getHistory() {
        return this.getHistoryRef().get();
    }

    public Reference<Space> getSpaceRef() {
        if (this.space == null) {
            return Reference.empty(Space.class);
        }
        return this.space;
    }

    public Space getSpace() {
        return this.space.get();
    }

    public Container getContainer() {
        if (this.container instanceof ContainerMap) {
            ContainerMap containerMap = (ContainerMap)this.container;
            return containerMap.convertTo(this.getContainerType());
        }
        return this.container;
    }

    protected Class getContainerType() {
        if (this.type.equals(ContentType.PAGE) || this.type.equals(ContentType.BLOG_POST)) {
            return Space.class;
        }
        return Content.class;
    }

    @JsonIgnore
    public ContentId getParentId() {
        Content parent = (Content)this.getParent().getOrNull();
        if (parent == null) {
            return ContentId.UNSET;
        }
        return parent.getId();
    }

    @JsonIgnore
    public Option<Content> getParent() {
        return this.getAncestors().size() > 0 ? Iterables.first(this.getAncestors()) : Option.none();
    }

    public List<Content> getAncestors() {
        return this.ancestors != null ? this.ancestors : ImmutableList.of();
    }

    public Map<ContentType, PageResponse<Content>> getChildren() {
        return this.children;
    }

    public Map<ContentType, PageResponse<Content>> getDescendants() {
        return this.descendants;
    }

    public Map<ContentRepresentation, ContentBody> getBody() {
        return this.body != null ? this.body : ImmutableMap.of();
    }

    public Map<String, Object> getMetadata() {
        return this.metadata != null ? this.metadata : ImmutableMap.of();
    }

    public Map<String, Object> getExtensions() {
        return this.extensions != null ? this.extensions : ImmutableMap.of();
    }

    public Object getExtension(String extensionKey) {
        return this.getExtensions().get(extensionKey);
    }

    public Reference<Version> getVersionRef() {
        if (this.version == null) {
            return Reference.empty(Version.class);
        }
        return this.version;
    }

    public Version getVersion() {
        return this.version != null && this.version.isExpanded() ? this.version.get() : null;
    }

    @Override
    public Navigation.Builder resolveNavigation(NavigationService navigationService) {
        return navigationService.createNavigation().content(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Content content = (Content)o;
        if (this.id == null || this.type == null) {
            return false;
        }
        if (!this.id.equals(content.id)) {
            return false;
        }
        if (!this.type.equals(content.type)) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(content.version) : content.version != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Content{id='" + this.id + '\'' + ", type=" + this.type + ", title='" + this.title + '\'' + ", space=" + this.space + ", version=" + this.version + ", ancestors=" + this.ancestors + '}';
    }

    public static class Expansions {
        public static final String ANCESTORS = "ancestors";
        public static final String BODY = "body";
        public static final String CHILDREN = "children";
        public static final String CONTAINER = "container";
        public static final String DESCENDANTS = "descendants";
        public static final String HISTORY = "history";
        public static final String METADATA = "metadata";
        public static final String PERMISSIONS = "permissions";
        public static final String SPACE = "space";
        public static final String STATUS = "status";
        public static final String VERSION = "version";
    }

    public static class ContentBuilder {
        private ContentId id = null;
        private ContentType type = null;
        private ContentStatus status = null;
        private String title = null;
        private ImmutableMap.Builder<LinkType, Link> links = ImmutableMap.builder();
        private Reference<History> history = null;
        private Reference<Space> space = Reference.empty(Space.class);
        private Container container = null;
        private ImmutableList.Builder<Content> ancestors;
        private ModelMapBuilder<ContentRepresentation, ContentBody> bodyMapBuilder = ModelMapBuilder.newInstance();
        private ModelMapBuilder<String, Object> metadata = ModelMapBuilder.newInstance();
        private ModelMapBuilder<String, Object> extensions = ModelMapBuilder.newExpandedInstance();
        private Reference<Version> version = null;
        private Map<ContentType, PageResponse<Content>> children;
        private Map<ContentType, PageResponse<Content>> descendants;

        private ContentBuilder() {
        }

        protected ContentBuilder(ContentType type) {
            this.type = type;
        }

        protected ContentBuilder(ContentType type, long id) {
            this.type = type;
            this.id = ContentId.of(type, id);
        }

        public ContentBuilder type(ContentType type) {
            this.type = type;
            return this;
        }

        public Content build() {
            return new Content(this);
        }

        public ContentBuilder id(ContentId id) {
            this.id = id;
            return this;
        }

        public ContentBuilder status(ContentStatus status) {
            this.status = status;
            return this;
        }

        public ContentBuilder title(String title) {
            this.title = title;
            return this;
        }

        public ContentBuilder addLink(Link link) {
            this.links.put((Object)link.getType(), (Object)link);
            return this;
        }

        public ContentBuilder addLink(LinkType type, String path) {
            return this.addLink(new Link(type, path));
        }

        public ContentBuilder history(Reference<History> history) {
            this.history = history;
            return this;
        }

        public ContentBuilder history(History history) {
            this.history = Reference.to(history);
            return this;
        }

        public ContentBuilder space(String spaceKey) {
            return this.space(Space.builder().key(spaceKey).build());
        }

        public ContentBuilder space(Space space) {
            return this.space(Reference.to(space));
        }

        public ContentBuilder space(Reference<Space> space) {
            this.space = space;
            return this;
        }

        public ContentBuilder container(Container container) {
            this.container = container;
            return this;
        }

        public ContentBuilder parent(Content parent) {
            if (this.type != null && !this.type.equals(parent.getType())) {
                throw new IllegalArgumentException(String.format("parent (%s) must be same type as this content (%s)", parent.getType(), this.type));
            }
            return this.ancestors((Iterable<Content>)ImmutableList.of((Object)parent));
        }

        public ContentBuilder ancestors(Iterable<Content> ancestors) {
            this.ancestors = BuilderUtils.safelyAddAllToBuilder(this.ancestors, ancestors);
            return this;
        }

        public ContentBuilder children(Map<ContentType, PageResponse<Content>> children) {
            this.children = children;
            return this;
        }

        public ContentBuilder descendants(Map<ContentType, PageResponse<Content>> descendants) {
            this.descendants = descendants;
            return this;
        }

        public ContentBuilder body(String value, ContentRepresentation format) {
            ContentBody contentBody = new ContentBody(format, value, this.id);
            this.bodyMapBuilder.put(format, contentBody);
            return this;
        }

        public ContentBuilder body(Map<ContentRepresentation, ContentBody> body) {
            this.bodyMapBuilder.copy(body);
            return this;
        }

        public ContentBuilder metadata(Map<String, Object> metadata) {
            this.metadata.copy(metadata);
            return this;
        }

        public ContentBuilder extensions(Map<String, Object> extensions) {
            this.extensions.copy(extensions);
            return this;
        }

        public ContentBuilder extension(String key, Object value) {
            this.extensions.put(key, value);
            return this;
        }

        public ContentBuilder version(Version version) {
            this.version = Reference.to(version);
            return this;
        }

        public ContentBuilder version(Reference<Version> version) {
            this.version = version;
            return this;
        }
    }

    private static enum IdProperties {
        id;

    }
}

