/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.search;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.fugue.Option;
import com.google.common.base.Strings;
import java.io.IOException;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;

@ExperimentalApi
@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchContext {
    public static final SearchContext EMPTY = SearchContext.builder().build();
    @JsonProperty
    private final String spaceKey;
    @JsonProperty
    private final ContentId contentId;

    @JsonCreator
    private SearchContext() {
        this(SearchContext.builder());
    }

    private SearchContext(Builder builder) {
        this.spaceKey = builder.spaceKey;
        this.contentId = builder.contentId;
    }

    public Option<ContentId> getContentId() {
        return Option.option((Object)this.contentId);
    }

    public Option<String> getSpaceKey() {
        return Option.option((Object)this.spaceKey);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SearchContext deserialize(String searchContextJson, ObjectMapper objectMapper) {
        if (Strings.isNullOrEmpty((String)searchContextJson)) {
            return null;
        }
        try {
            return (SearchContext)objectMapper.readValue(searchContextJson, SearchContext.class);
        }
        catch (IOException ex) {
            throw new BadRequestException("Could not parse Search Context from cql context param " + searchContextJson, ex);
        }
    }

    public static class Builder {
        private String spaceKey;
        private ContentId contentId;

        private Builder() {
        }

        public Builder spaceKey(String spaceKey) {
            this.spaceKey = spaceKey;
            return this;
        }

        public Builder contentId(ContentId contentId) {
            this.contentId = contentId;
            return this;
        }

        public SearchContext build() {
            return new SearchContext(this);
        }
    }
}

