/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.journal;

import com.atlassian.annotations.PublicApi;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@PublicApi
public class JournalEntry {
    private final long id;
    private final JournalIdentifier journalId;
    private final Date creationDate;
    private final String type;
    private final String message;

    public JournalEntry(JournalIdentifier journalId, String type, @Nullable String message) {
        Preconditions.checkArgument((type.length() <= 255 ? 1 : 0) != 0, (Object)"type cannot exceed 255 characters");
        Preconditions.checkArgument((message == null || message.length() <= 2047 ? 1 : 0) != 0, (Object)"message cannot exceed 2047 characters");
        this.id = 0L;
        this.journalId = (JournalIdentifier)Preconditions.checkNotNull((Object)journalId);
        this.creationDate = null;
        this.type = type;
        this.message = message;
    }

    public JournalEntry(long id, JournalIdentifier journalId, Date creationDate, String type, @Nullable String message) {
        Preconditions.checkArgument((id > 0L ? 1 : 0) != 0, (Object)"not a valid id");
        Preconditions.checkArgument((type.length() <= 255 ? 1 : 0) != 0, (Object)"type cannot exceed 255 characters");
        Preconditions.checkArgument((message == null || message.length() <= 2047 ? 1 : 0) != 0, (Object)"message cannot exceed 2047 characters");
        this.id = id;
        this.journalId = (JournalIdentifier)Preconditions.checkNotNull((Object)journalId);
        this.creationDate = (Date)Preconditions.checkNotNull((Object)creationDate);
        this.type = type;
        this.message = message;
    }

    public long getId() {
        return this.id;
    }

    public JournalIdentifier getJournalId() {
        return this.journalId;
    }

    public Date getCreationDate() {
        return new Date(this.creationDate.getTime());
    }

    public String getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object o) {
        if (o instanceof JournalEntry) {
            return this.id == ((JournalEntry)o).id;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", this.id).add("journalId", (Object)this.journalId).add("creationDate", (Object)this.creationDate).add("type", (Object)this.type).add("message", (Object)this.message).toString();
    }
}

