/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.model.relations;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.Space;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.relations.Relatable;
import com.atlassian.confluence.api.model.relations.RelationDescriptor;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import java.lang.reflect.ParameterizedType;

@ExperimentalSpi
public abstract class AbstractRelationDescriptor<S extends Relatable, T extends Relatable>
implements RelationDescriptor<S, T> {
    private final String relationName;
    private Class<S> sourceClass;
    private Class<T> targetClass;

    protected AbstractRelationDescriptor(String relationName) {
        this.relationName = relationName;
    }

    protected AbstractRelationDescriptor(String relationName, Class<S> sourceClass, Class<T> targetClass) {
        this(relationName);
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
    }

    @Override
    public Class<S> getSourceClass() {
        if (this.sourceClass == null) {
            this.sourceClass = this.getGenericTypeArgs(0);
        }
        return this.sourceClass;
    }

    @Override
    public Class<T> getTargetClass() {
        if (this.targetClass == null) {
            this.targetClass = this.getGenericTypeArgs(1);
        }
        return this.targetClass;
    }

    @Override
    public String getRelationName() {
        return this.relationName;
    }

    @Override
    public ValidationResult canRelate(S source, T target) {
        SimpleValidationResult.Builder resultBuilder = SimpleValidationResult.builder().authorized(true);
        if ((source instanceof Space || source instanceof Content) && target instanceof User) {
            resultBuilder.addError("Unrecognised source / type combination", new Object[0]);
        }
        return resultBuilder.build();
    }

    protected Class getGenericTypeArgs(int i) {
        ParameterizedType thisAbstractRelation = (ParameterizedType)this.getClass().getGenericSuperclass();
        return (Class)thisAbstractRelation.getActualTypeArguments()[i];
    }
}

