/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.event.events.admin.AsyncImportFinishedEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.UserSpaceImportJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.model.UserSpaceImportModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSpaceImportCommand
implements Command<AsyncImportFinishedEvent, UserManagementInSyncModel>,
CommandCreator<AsyncImportFinishedEvent, UserManagementInSyncModel> {
    private static final Logger logger = LoggerFactory.getLogger(UserSpaceImportCommand.class);
    private final UserGroupCommandSupport commandSupport;

    public UserSpaceImportCommand(UserGroupCommandSupport commandSupport) {
        this.commandSupport = commandSupport;
    }

    public void processEvent(AsyncImportFinishedEvent event, Object ... parameters) {
        if (event.isSiteImport()) {
            return;
        }
        UserSpaceImportJournalMessage userSpaceImportJournalMessage = new UserSpaceImportJournalMessage(event.getImportContext().getSpaceKeyOfSpaceImport());
        this.commandSupport.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.USER_SPACE_RESTORE_ENTRY), userSpaceImportJournalMessage);
    }

    public Collection<UserManagementInSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<UserManagementInSyncModel> result = new ArrayList<UserManagementInSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            Optional<UserSpaceImportJournalMessage> userSpaceImportJournalMessageOptional = this.commandSupport.deserializeJournalMessage(UserSpaceImportJournalMessage.class, journalEntry);
            if (userSpaceImportJournalMessageOptional.isEmpty()) {
                logger.error("Could not deserialize Journal Entry, Journal Id [{}] with message [{}]", (Object)journalEntry.getId(), (Object)journalEntry.getMessage());
                return result;
            }
            UserSpaceImportJournalMessage userSpaceImportJournalMessage = userSpaceImportJournalMessageOptional.get();
            UserJournalEntryTypes entryType = UserJournalEntryTypes.valueOf(journalEntry.getType());
            result.add(new UserSpaceImportModel(journalEntry.getId(), userSpaceImportJournalMessage.getSpaceKey(), UserModelType.SPACE_RESTORE, entryType.getJsonModelOperation()));
        }
        return result;
    }

    public Optional<Command<AsyncImportFinishedEvent, UserManagementInSyncModel>> newCommand(AsyncImportFinishedEvent event) {
        return Optional.of(new UserSpaceImportCommand(this.commandSupport));
    }

    public Optional<Command<AsyncImportFinishedEvent, UserManagementInSyncModel>> newCommand(JournalEntry journalEntry) {
        boolean isSpaceRestoreEntry = UserJournalEntryTypes.USER_SPACE_RESTORE_ENTRY.name().equals(journalEntry.getType());
        if (!isSpaceRestoreEntry) {
            return Optional.empty();
        }
        return Optional.of(new UserSpaceImportCommand(this.commandSupport));
    }
}

