/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.impl.service.content.factory.PersonFactory;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.people.KnownUser;
import com.atlassian.confluence.api.model.people.Person;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.UserJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.model.UserEventModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserEventCommand<T>
implements Command<T, UserManagementInSyncModel>,
CommandCreator<T, UserManagementInSyncModel> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final UserGroupCommandSupport commandSupport;
    protected final PersonFactory personFactory;

    protected UserEventCommand(UserGroupCommandSupport commandSupport, PersonFactory personFactory) {
        this.commandSupport = Objects.requireNonNull(commandSupport);
        this.personFactory = Objects.requireNonNull(personFactory);
    }

    public Collection<UserManagementInSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<UserManagementInSyncModel> result = new ArrayList<UserManagementInSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            Optional<UserJournalMessage> optUserJournalMessage = this.commandSupport.deserializeJournalMessage(UserJournalMessage.class, journalEntry);
            if (optUserJournalMessage.isEmpty()) {
                this.logger.error("Could not deserialize Journal Entry, Journal Id [{}] with message [{}]", (Object)journalEntry.getId(), (Object)journalEntry.getMessage());
                continue;
            }
            UserJournalMessage userJournalMessage = optUserJournalMessage.orElseThrow();
            UserJournalEntryTypes entryType = UserJournalEntryTypes.valueOf(journalEntry.getType());
            Person userDetail = this.personFactory.forUserKeyWithoutProfile(userJournalMessage.getUserKey(), Expansions.of((String[])new String[]{"status"}));
            if (!(userDetail instanceof KnownUser)) continue;
            result.add(new UserEventModel(journalEntry.getId(), UserModelType.USER_MANAGEMENT.getName(), entryType.getJsonModelOperation().getName(), userDetail));
        }
        return result;
    }
}

