/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.GroupJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.model.GroupEventModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GroupEventCommand<T>
implements Command<T, UserManagementInSyncModel>,
CommandCreator<T, UserManagementInSyncModel> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final UserGroupCommandSupport commandSupport;

    protected GroupEventCommand(UserGroupCommandSupport commandSupport) {
        this.commandSupport = Objects.requireNonNull(commandSupport);
    }

    public Collection<UserManagementInSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<UserManagementInSyncModel> result = new ArrayList<UserManagementInSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            Optional<GroupJournalMessage> groupEventJournalMessageOptional = this.commandSupport.deserializeJournalMessage(GroupJournalMessage.class, journalEntry);
            if (groupEventJournalMessageOptional.isEmpty()) {
                this.logger.error("Could not deserialize group journal. Journal id [{}] , message: [{}]", (Object)journalEntry.getJournalId(), (Object)journalEntry.getMessage());
                continue;
            }
            GroupJournalMessage groupEventJournalMessage = groupEventJournalMessageOptional.orElseThrow();
            UserJournalEntryTypes entryType = UserJournalEntryTypes.valueOf(journalEntry.getType());
            result.add(new GroupEventModel(journalEntry.getId(), groupEventJournalMessage.getGroupName(), UserModelType.GROUP_MANAGEMENT, entryType.getJsonModelOperation()));
        }
        return result;
    }
}

