/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.commands;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.UserGroupCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.UserModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.journalmessage.ApplicationJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.usermanagement.model.UserGroupIncrementalSyncEventModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.usermanagement.UserManagementInSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import com.atlassian.crowd.event.application.ApplicationUpdatedEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationUpdatedEventCommand
implements Command<ApplicationUpdatedEvent, UserManagementInSyncModel>,
CommandCreator<ApplicationUpdatedEvent, UserManagementInSyncModel> {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationUpdatedEventCommand.class);
    private final UserGroupCommandSupport commandSupport;

    public ApplicationUpdatedEventCommand(UserGroupCommandSupport commandSupport) {
        this.commandSupport = commandSupport;
    }

    public void processEvent(ApplicationUpdatedEvent event, Object ... parameters) {
        boolean hasMembershipAggregationChanged;
        boolean bl = hasMembershipAggregationChanged = event.getOldApplication().isMembershipAggregationEnabled() != event.getApplication().isMembershipAggregationEnabled();
        if (!hasMembershipAggregationChanged) {
            return;
        }
        ApplicationJournalMessage applicationJournalMessage = new ApplicationJournalMessage(System.currentTimeMillis(), event.getApplicationId());
        this.commandSupport.enqueueForUserManagement(String.valueOf((Object)UserJournalEntryTypes.APPLICATION_UPDATED_ENTRY), applicationJournalMessage);
    }

    public Collection<UserManagementInSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<UserManagementInSyncModel> result = new ArrayList<UserManagementInSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            Optional<ApplicationJournalMessage> applicationJournalMessageOptional = this.commandSupport.deserializeJournalMessage(ApplicationJournalMessage.class, journalEntry);
            if (applicationJournalMessageOptional.isEmpty()) {
                logger.error("Could not deserialize Journal Entry, Journal Id [{}] with message [{}]", (Object)journalEntry.getId(), (Object)journalEntry.getMessage());
                return result;
            }
            ApplicationJournalMessage applicationJournalMessage = applicationJournalMessageOptional.orElseThrow();
            UserJournalEntryTypes entryType = UserJournalEntryTypes.valueOf(journalEntry.getType());
            result.add(new UserGroupIncrementalSyncEventModel(journalEntry.getId(), applicationJournalMessage.getApplicationId(), UserModelType.APPLICATION_MANAGEMENT, entryType.getJsonModelOperation()));
        }
        return result;
    }

    public Optional<Command<ApplicationUpdatedEvent, UserManagementInSyncModel>> newCommand(ApplicationUpdatedEvent event) {
        return Optional.of(new ApplicationUpdatedEventCommand(this.commandSupport));
    }

    public Optional<Command<ApplicationUpdatedEvent, UserManagementInSyncModel>> newCommand(JournalEntry journalEntry) {
        boolean isApplicationUpdatedEntry = UserJournalEntryTypes.APPLICATION_UPDATED_ENTRY.name().equals(journalEntry.getType());
        if (!isApplicationUpdatedEntry) {
            return Optional.empty();
        }
        return Optional.of(new ApplicationUpdatedEventCommand(this.commandSupport));
    }
}

