/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal;

import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.incrementalsync.IncrementalSyncSubscriptionManager;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.MultiSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.ServerSubscriptionJournalStateStore;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncSubscription;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.dao.DataAccessException;

public class ClientSubscriptionJournalStateStore
extends ServerSubscriptionJournalStateStore {
    public ClientSubscriptionJournalStateStore(String subscriptionContextKey, IncrementalSyncSubscriptionManager incrementalSyncSubscriptionManager) {
        super(subscriptionContextKey, incrementalSyncSubscriptionManager);
    }

    @Override
    public long getMostRecentId(@NonNull JournalIdentifier journalId) throws DataAccessException {
        if (!(journalId instanceof MultiSubscriptionPerJournalIdentifier)) {
            throw new IllegalArgumentException("Invalid journal identifier: " + String.valueOf(journalId));
        }
        MultiSubscriptionPerJournalIdentifier subscriptionJournalIdentifier = (MultiSubscriptionPerJournalIdentifier)journalId;
        IncrementalSyncSubscription value = this.getSubscriptionStateData(subscriptionJournalIdentifier).orElseThrow(() -> new IllegalArgumentException("Invalid subscription id"));
        value.setMostRecentId(subscriptionJournalIdentifier.getMostRecentId());
        this.saveSubscriptionStateData(value);
        return subscriptionJournalIdentifier.getMostRecentId();
    }

    @Override
    protected String getKeyPrefix() {
        return "CLIENT_";
    }
}

