/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentRemoveEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentTrashedEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostTrashedEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.ContentCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands.ContentManagementMultiEventsCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.journalmessage.ContentJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.model.ContentModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.util.ObjectMapperProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ContentRemoveCommand
extends ContentManagementMultiEventsCommand<ContentEvent> {
    private final ContentService contentService;
    protected final ObjectMapper objectMapper;

    public ContentRemoveCommand(ContentCommandSupport commandSupport, ContentService contentService) {
        super(commandSupport);
        this.contentService = contentService;
        this.objectMapper = new ObjectMapperProvider().getObjectMapper();
    }

    @Override
    protected Map<Class<? extends ContentEvent>, ContentJournalEntryTypes> getSupportedEventEntryTypesMap() {
        if (this.supportedEventEntryTypesMap == null) {
            this.supportedEventEntryTypesMap = Map.of(PageTrashedEvent.class, ContentJournalEntryTypes.CONTENT_TRASHED_ENTRY, BlogPostTrashedEvent.class, ContentJournalEntryTypes.CONTENT_TRASHED_ENTRY, AttachmentTrashedEvent.class, ContentJournalEntryTypes.CONTENT_TRASHED_ENTRY, PageRemoveEvent.class, ContentJournalEntryTypes.CONTENT_DELETED_ENTRY, BlogPostRemoveEvent.class, ContentJournalEntryTypes.CONTENT_DELETED_ENTRY, CommentRemoveEvent.class, ContentJournalEntryTypes.CONTENT_DELETED_ENTRY, AttachmentRemoveEvent.class, ContentJournalEntryTypes.CONTENT_DELETED_ENTRY);
        }
        return this.supportedEventEntryTypesMap;
    }

    @Override
    protected List<JournalMessage> createMessages(ContentEvent event) {
        if (event instanceof PageRemoveEvent || event instanceof PageTrashedEvent) {
            Page page = ((PageEvent)event).getPage();
            if (!Objects.equals(page.getContentStatus(), "draft")) {
                return this.createJournalMessagesFor((ContentEntityObject)page);
            }
        } else if (event instanceof BlogPostRemoveEvent || event instanceof BlogPostTrashedEvent) {
            BlogPost blogPost = ((BlogPostEvent)event).getBlogPost();
            if (!Objects.equals(blogPost.getContentStatus(), "draft")) {
                return this.createJournalMessagesFor((ContentEntityObject)blogPost);
            }
        } else {
            if (event instanceof AttachmentRemoveEvent || event instanceof AttachmentTrashedEvent) {
                Attachment attachment = ((AttachmentEvent)event).getAttachment();
                return List.of(new ContentJournalMessage(Instant.now().toEpochMilli(), attachment.getId(), ContentType.ATTACHMENT));
            }
            if (event instanceof CommentRemoveEvent) {
                CommentRemoveEvent contentRemoveEvent = (CommentRemoveEvent)event;
                Comment comment = contentRemoveEvent.getComment();
                return this.createJournalMessagesFor((ContentEntityObject)comment);
            }
        }
        return Collections.emptyList();
    }

    private List<JournalMessage> createJournalMessagesFor(ContentEntityObject ceo) {
        ArrayList relatedContents = new ArrayList();
        if (ceo.getComments() != null && !ceo.getComments().isEmpty()) {
            relatedContents.addAll(ceo.getComments());
        }
        if (ceo.getAttachments() != null && !ceo.getAttachments().isEmpty()) {
            relatedContents.addAll(ceo.getAttachments());
        }
        return this.removeWithRelatedContentMessages(ceo, Instant.now().toEpochMilli(), relatedContents);
    }

    public Collection<ContentManagementIncSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        ArrayList<ContentManagementIncSyncModel> contentRemovedModels = new ArrayList<ContentManagementIncSyncModel>();
        for (JournalEntry journalEntry : journalEntries) {
            ContentJournalEntryTypes entryType = ContentJournalEntryTypes.valueOf(journalEntry.getType());
            this.commandSupport.deserializeJournalMessage(ContentJournalMessage.class, journalEntry).ifPresent(journalMessage -> {
                Content content = Content.builder().id(ContentId.of((long)journalMessage.getContentId())).type(journalMessage.getContentType()).build();
                contentRemovedModels.add(new ContentModel(journalEntry.getId(), ContentModelType.CONTENT_MANAGEMENT_CONTENT.getName(), entryType.getJsonModelOperation().getName(), content));
            });
        }
        return contentRemovedModels;
    }

    public Optional<Command<ContentEvent, ContentManagementIncSyncModel>> newCommand(ContentEvent event) {
        return this.getSupportedEventEntryTypesMap().containsKey(event.getClass()) ? Optional.of(new ContentRemoveCommand(this.commandSupport, this.contentService)) : Optional.empty();
    }

    public Optional<Command<ContentEvent, ContentManagementIncSyncModel>> newCommand(JournalEntry journalEntry) {
        return super.newCommand(journalEntry, new ContentRemoveCommand(this.commandSupport, this.contentService));
    }

    private List<JournalMessage> removeWithRelatedContentMessages(ContentEntityObject content, long timestamp, List<? extends ContentEntityObject> relatedContents) {
        return this.withRelatedContentMessages(content, timestamp, relatedContents, false);
    }
}

