/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.permission.ContentTreePermissionReindexEvent;
import com.atlassian.confluence.event.events.security.ContentPermissionEvent;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.ContentCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentExpansions;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentModelType;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands.ContentManagementMultiEventsCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.journalmessage.ContentJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.model.ContentModel;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ContentPermissionChangeCommand
extends ContentManagementMultiEventsCommand<ContentEvent> {
    private final ContentService contentService;

    public ContentPermissionChangeCommand(ContentCommandSupport commandSupport, ContentService contentService) {
        super(commandSupport);
        this.contentService = contentService;
        this.supportedEventEntryTypesMap = Map.of(ContentPermissionEvent.class, ContentJournalEntryTypes.CONTENT_PERMISSIONS_UPDATED_ENTRY, ContentTreePermissionReindexEvent.class, ContentJournalEntryTypes.CONTENT_PERMISSIONS_UPDATED_ENTRY);
    }

    @Override
    protected List<JournalMessage> createMessages(ContentEvent event) {
        if (event instanceof ContentPermissionEvent) {
            ContentPermissionEvent contentPermissionEvent = (ContentPermissionEvent)event;
            this.logger.debug("Handling content permission event: {}", (Object)event);
            ContentEntityObject content = contentPermissionEvent.getContent();
            return List.of(new ContentJournalMessage(Instant.now().toEpochMilli(), content.getId(), ContentType.valueOf((String)content.getType())));
        }
        if (event instanceof ContentTreePermissionReindexEvent) {
            ContentTreePermissionReindexEvent contentTreePermissionReindexEvent = (ContentTreePermissionReindexEvent)event;
            this.logger.debug("Handling content tree permission reindex event: {}", (Object)event);
            ContentEntityObject content = contentTreePermissionReindexEvent.getContent();
            return List.of(new ContentJournalMessage(Instant.now().toEpochMilli(), content.getId(), ContentType.valueOf((String)content.getType())));
        }
        return Collections.emptyList();
    }

    @Override
    protected Map<Class<? extends ContentEvent>, ContentJournalEntryTypes> getSupportedEventEntryTypesMap() {
        return this.supportedEventEntryTypesMap;
    }

    public Collection<ContentManagementIncSyncModel> processJournalEntries(Collection<JournalEntry> journalEntries) {
        Map<ContentId, JournalEntry> contentIdContentJournalMessageMap = this.deserializeJournalMessage(journalEntries);
        PageResponse contentPageResponse = this.contentService.find(ContentExpansions.defaultExpansions()).withId(contentIdContentJournalMessageMap.keySet()).fetchManyWithAnyType((PageRequest)new SimplePageRequest(LimitedRequestImpl.create((int)contentIdContentJournalMessageMap.size())));
        return contentPageResponse.getResults().stream().map(content -> {
            JournalEntry journalEntry = (JournalEntry)contentIdContentJournalMessageMap.get(content.getId());
            ContentJournalEntryTypes entryType = ContentJournalEntryTypes.valueOf(journalEntry.getType());
            Content updatedContent = !content.getAncestors().isEmpty() ? this.buildContentWithDirectAncestor((Content)content) : content;
            return new ContentModel(journalEntry.getId(), ContentModelType.CONTENT_MANAGEMENT_RESTRICTION.getName(), entryType.getJsonModelOperation().getName(), updatedContent);
        }).toList();
    }

    public Optional<Command<ContentEvent, ContentManagementIncSyncModel>> newCommand(ContentEvent event) {
        return this.getSupportedEventEntryTypesMap().containsKey(event.getClass()) ? Optional.of(new ContentPermissionChangeCommand(this.commandSupport, this.contentService)) : Optional.empty();
    }

    public Optional<Command<ContentEvent, ContentManagementIncSyncModel>> newCommand(JournalEntry journalEntry) {
        return super.newCommand(journalEntry, new ContentPermissionChangeCommand(this.commandSupport, this.contentService));
    }

    private Map<ContentId, JournalEntry> deserializeJournalMessage(Collection<JournalEntry> journalEntries) {
        HashMap<ContentId, JournalEntry> contentIdToJournalEntry = new HashMap<ContentId, JournalEntry>();
        journalEntries.forEach(journalEntry -> {
            Optional<ContentJournalMessage> optionalContentJournalMessage = this.commandSupport.deserializeJournalMessage(ContentJournalMessage.class, (JournalEntry)journalEntry);
            if (optionalContentJournalMessage.isEmpty()) {
                this.logger.warn("Unable to deserialize journal message {}", journalEntry);
                return;
            }
            ContentJournalMessage journalMessage = optionalContentJournalMessage.get();
            contentIdToJournalEntry.put(ContentId.of((long)journalMessage.getContentId()), (JournalEntry)journalEntry);
        });
        return contentIdToJournalEntry;
    }
}

