/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.commands;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.ContentCommandSupport;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.JournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.MultiEventsCommand;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.ContentJournalEntryTypes;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.contentmanagement.journalmessage.ContentJournalMessage;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.journal.SingleSubscriptionPerJournalIdentifier;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import com.atlassian.confluence.internal.api.incrementalsync.model.contentmanagement.ContentManagementIncSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class ContentManagementMultiEventsCommand<T>
extends MultiEventsCommand<T, ContentManagementIncSyncModel, ContentJournalEntryTypes> {
    protected final ContentCommandSupport commandSupport;

    protected ContentManagementMultiEventsCommand(ContentCommandSupport commandSupport) {
        this.commandSupport = commandSupport;
    }

    protected abstract List<JournalMessage> createMessages(T var1);

    public void processEvent(T event, Object ... params) {
        ContentJournalEntryTypes entryType = (ContentJournalEntryTypes)((Object)this.getSupportedEventEntryTypesMap().get(event.getClass()));
        if ((entryType = this.getEntryTypeForEvent(entryType, event)) == null) {
            this.logger.debug("No entry type found for event {}", (Object)event.getClass().getName());
            return;
        }
        List<JournalMessage> messages = this.createMessages(event);
        if (messages.isEmpty()) {
            this.logger.warn("Error creating message for event {}", (Object)event.getClass().getName());
            return;
        }
        if (!this.commandSupport.validateContentManagementCommandParam(params)) {
            this.logger.debug("Validating parameters failed when processing event {}", event);
            return;
        }
        SubscriptionId subscriptionId = (SubscriptionId)params[0];
        SingleSubscriptionPerJournalIdentifier subscriptionJournalIdentifier = new SingleSubscriptionPerJournalIdentifier("c_g_inc_sync", subscriptionId);
        for (JournalMessage message : messages) {
            this.commandSupport.enqueueForContentManagement(subscriptionJournalIdentifier, String.valueOf((Object)entryType), message);
        }
    }

    public Optional<Command<T, ContentManagementIncSyncModel>> newCommand(JournalEntry journalEntry, Command<T, ContentManagementIncSyncModel> command) {
        ContentJournalEntryTypes entryType;
        try {
            entryType = ContentJournalEntryTypes.valueOf(journalEntry.getType());
        }
        catch (IllegalArgumentException ex) {
            this.logger.debug("Invalid journal entry type {}", (Object)journalEntry.getType(), (Object)ex);
            return Optional.empty();
        }
        if (!this.getSupportedEventEntryTypesMap().containsValue((Object)entryType)) {
            this.logger.debug("Unsupported journal entry type {}", (Object)entryType);
            return Optional.empty();
        }
        return Optional.of(command);
    }

    protected ContentJournalEntryTypes getEntryTypeForEvent(ContentJournalEntryTypes mappingEntryType, T event) {
        return mappingEntryType;
    }

    protected Content buildContentWithDirectAncestor(Content content) {
        Content parent;
        ContentType contentType = content.getType();
        if (contentType == ContentType.PAGE) {
            List ancestors = content.getAncestors();
            parent = (Content)ancestors.get(ancestors.size() - 1);
        } else if (contentType == ContentType.COMMENT) {
            parent = null;
        } else {
            throw new IllegalArgumentException("Unsupported content type when building content with a single ancestor: " + String.valueOf(contentType));
        }
        return Content.builder((Content)content).parent(parent).build();
    }

    protected List<JournalMessage> withRelatedContentMessages(ContentEntityObject content, long timestamp, List<? extends ContentEntityObject> relatedContents, boolean isRestore) {
        List messages = relatedContents.stream().map(relatedContent -> new ContentJournalMessage(timestamp, relatedContent.getId(), ContentType.valueOf((String)relatedContent.getType()))).collect(Collectors.toList());
        ContentJournalMessage message = new ContentJournalMessage(timestamp, content.getId(), ContentType.valueOf((String)content.getType()));
        if (isRestore) {
            messages.add(0, message);
        } else {
            messages.add(message);
        }
        return Collections.unmodifiableList(messages);
    }
}

