/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.internal.api.impl.service.incrementalsync;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.internal.api.impl.service.incrementalsync.utils.IncrementalSyncUtil;
import com.atlassian.confluence.internal.api.incrementalsync.model.CommandFactory;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncModel;
import com.atlassian.confluence.internal.api.service.incrementalsync.Command;
import com.atlassian.confluence.internal.api.service.incrementalsync.CommandCreator;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandFactoryImpl<M extends IncrementalSyncModel>
implements CommandFactory<M> {
    private static final Logger logger = LoggerFactory.getLogger(CommandFactoryImpl.class);
    private final Collection<CommandCreator<?, M>> commandCreators;

    public CommandFactoryImpl(Collection<CommandCreator<?, M>> commandCreators) {
        this.commandCreators = Objects.requireNonNull(commandCreators);
    }

    public <T> Optional<Command<T, M>> createCommand(Class<?> eventClass, T event) {
        logger.debug("Creating command for event {}", eventClass);
        for (CommandCreator<?, M> commandCreator : this.getCommandCreators()) {
            Object command = IncrementalSyncUtil.invokeFactoryMethodForEvent(commandCreator, eventClass, event);
            if (command == null) continue;
            logger.debug("Found a command creator {}", commandCreator);
            Optional commandOptional = (Optional)command;
            if (!commandOptional.isPresent()) continue;
            return commandOptional;
        }
        return Optional.empty();
    }

    public Optional<Command<?, M>> createCommand(JournalEntry journalEntry) {
        logger.debug("Creating command for journal entry {}", (Object)journalEntry.getType());
        for (CommandCreator<?, M> commandCreator : this.getCommandCreators()) {
            Command concreteCommand = commandCreator.newCommand(journalEntry).orElse(null);
            if (concreteCommand == null) continue;
            return Optional.of(concreteCommand);
        }
        return Optional.empty();
    }

    protected Collection<CommandCreator<?, M>> getCommandCreators() {
        return this.commandCreators;
    }
}

