/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.permissions;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.model.people.Anonymous;
import com.atlassian.confluence.api.model.people.Subject;
import com.atlassian.confluence.api.model.people.UnknownUser;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.model.permissions.GlobalPermission;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.api.service.permissions.GlobalPermissionService;
import com.atlassian.confluence.api.service.permissions.SpacePermissionOperationKeyConverter;
import com.atlassian.confluence.dmz.security.delegate.ScopesRequestCacheDelegate;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermission;
import com.atlassian.confluence.security.administrators.PermissionsAdministrator;
import com.atlassian.confluence.security.administrators.PermissionsAdministratorBuilder;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.Group;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalPermissionServiceImpl
implements GlobalPermissionService {
    private static final Logger log = LoggerFactory.getLogger(GlobalPermissionServiceImpl.class);
    private final SpacePermissionOperationKeyConverter spacePermissionOperationKeyConverter;
    private final PermissionsAdministrator permissionsAdministrator;
    private final PermissionManager permissionManager;
    private final UserAccessor userAccessor;
    private final ScopesRequestCacheDelegate scopesRequestCacheDelegate;

    public GlobalPermissionServiceImpl(SpacePermissionOperationKeyConverter spacePermissionOperationKeyConverter, PermissionsAdministratorBuilder permissionsAdministratorBuilder, PermissionManager permissionManager, UserAccessor userAccessor, ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        this(spacePermissionOperationKeyConverter, permissionsAdministratorBuilder.buildGlobalPermissionAdministrator(), permissionManager, userAccessor, scopesRequestCacheDelegate);
    }

    @VisibleForTesting
    GlobalPermissionServiceImpl(SpacePermissionOperationKeyConverter spacePermissionOperationKeyConverter, PermissionsAdministrator permissionsAdministrator, PermissionManager permissionManager, UserAccessor userAccessor, ScopesRequestCacheDelegate scopesRequestCacheDelegate) {
        this.spacePermissionOperationKeyConverter = spacePermissionOperationKeyConverter;
        this.permissionsAdministrator = permissionsAdministrator;
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
        this.scopesRequestCacheDelegate = scopesRequestCacheDelegate;
    }

    public List<GlobalPermission> getAllPermissions() {
        this.validateApplicationAdministerPermissionOrReadAllScope();
        List globalPermissions = this.permissionsAdministrator.getPermissions();
        return this.convertPermissions(globalPermissions);
    }

    public List<GlobalPermission> getPermissionsGrantedToUser(UserKey userKey) {
        this.validateApplicationAdministerPermissionOrReadAllScope();
        ConfluenceUser confluenceUser = this.getConfluenceUser(userKey);
        List globalPermissions = this.permissionsAdministrator.getPermissions();
        List<SpacePermission> userPermissions = globalPermissions.stream().filter(permission -> permission.isUserPermission() && Objects.equals(confluenceUser.getKey(), permission.getUserSubject() == null ? null : permission.getUserSubject().getKey())).toList();
        return this.convertPermissions(userPermissions);
    }

    public List<GlobalPermission> getPermissionsGrantedToGroup(String groupName) {
        this.validateGroup(groupName);
        this.validateApplicationAdministerPermissionOrReadAllScope();
        List globalPermissions = this.permissionsAdministrator.getPermissions();
        List<SpacePermission> userPermissions = globalPermissions.stream().filter(permission -> permission.isGroupPermission() && groupName.equals(permission.getGroup())).toList();
        return this.convertPermissions(userPermissions);
    }

    public List<GlobalPermission> getPermissionsGrantedToAnonymousUsers() {
        this.validateApplicationAdministerPermissionOrReadAllScope();
        List globalPermissions = this.permissionsAdministrator.getPermissions();
        List<SpacePermission> userPermissions = globalPermissions.stream().filter(SpacePermission::isAnonymousPermission).toList();
        return this.convertPermissions(userPermissions);
    }

    public List<GlobalPermission> getPermissionsGrantedToUnlicensedUsers() {
        this.validateApplicationAdministerPermissionOrReadAllScope();
        List globalPermissions = this.permissionsAdministrator.getPermissions();
        List<SpacePermission> userPermissions = globalPermissions.stream().filter(SpacePermission::isAuthenticatedUsersPermission).toList();
        return this.convertPermissions(userPermissions);
    }

    protected ConfluenceUser getAuthenticatedUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    private void validateGroup(String groupName) {
        Group groupEntity = this.userAccessor.getGroup(groupName);
        if (groupEntity == null) {
            throw new NotFoundException("Group with the given name is not found. name: " + groupName);
        }
    }

    private List<GlobalPermission> convertPermissions(List<SpacePermission> spacePermissions) {
        return spacePermissions.stream().map(this::convertPermission).collect(Collectors.toList());
    }

    private GlobalPermission convertPermission(SpacePermission spacePermission) {
        GlobalPermission permission = new GlobalPermission();
        permission.setSubject(this.getSubjectFromSpacePermission(spacePermission));
        permission.setOperation(this.spacePermissionOperationKeyConverter.toOperation(spacePermission.getType()));
        if (spacePermission.getSpace() != null) {
            log.debug("Global permission should not have a space. Permission detail is {}", (Object)spacePermission);
            throw new IllegalArgumentException("Global permission should not have a space.");
        }
        return permission;
    }

    private ConfluenceUser getConfluenceUser(UserKey userKey) {
        ConfluenceUser user = this.userAccessor.getUserByKey(userKey);
        if (user == null) {
            throw new NotFoundException("User with the given key is not found. userKey: " + String.valueOf(userKey));
        }
        return user;
    }

    private Subject getSubjectFromSpacePermission(SpacePermission permission) {
        if (permission.isGroupPermission()) {
            return com.atlassian.confluence.api.model.people.Group.builder().name(permission.getGroup()).build();
        }
        if (permission.isAnonymousPermission()) {
            return Anonymous.ANONYMOUS_USER;
        }
        if (permission.isAuthenticatedUsersPermission()) {
            return new UnknownUser(null, null);
        }
        ConfluenceUser user = permission.getUserSubject();
        if (permission.isUserPermission() && user != null) {
            return User.fromUserkey((UserKey)user.getKey());
        }
        throw new IllegalArgumentException("Unknown subject for permission " + String.valueOf(permission));
    }

    private void validateApplicationAdministerPermissionOrReadAllScope() {
        if (!this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION) && !this.scopesRequestCacheDelegate.isScopePermitted("READ_ALL")) {
            throw new PermissionException("User does not have sufficient permission");
        }
    }
}

