/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.datetime;

import com.atlassian.confluence.api.service.datetime.DateFormatService;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.datetime.FriendlyDateFormatter;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserPreferencesAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.i18n.Message;
import com.atlassian.core.util.Clock;
import com.atlassian.user.User;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.Locale;

public class DateFormatServiceImpl
implements DateFormatService {
    private static final String ADG_DATE_FORMAT = "dd MMM yyyy";
    private final UserPreferencesAccessor userPreferencesAccessor;
    private final FormatSettingsManager formatSettingsManager;
    private final LocaleManager localeManager;
    private final I18NBeanFactory i18NBeanFactory;
    private final Clock clock;

    public DateFormatServiceImpl(UserPreferencesAccessor userPreferencesAccessor, FormatSettingsManager formatSettingsManager, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, Clock clock) {
        this.userPreferencesAccessor = userPreferencesAccessor;
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.clock = clock;
    }

    public String getFormattedDateByUserLocale(LocalDate date) {
        if (date == null) {
            return null;
        }
        Locale locale = this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get());
        if (this.getFormatForADG(locale)) {
            return DateTimeFormatter.ofPattern(ADG_DATE_FORMAT, locale).format(date);
        }
        return DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(locale).format(date);
    }

    private boolean getFormatForADG(Locale locale) {
        return Locale.UK.equals(locale) || Locale.US.equals(locale);
    }

    public String getDateFormatPatternForUser() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Locale locale = this.localeManager.getLocale((User)user);
        if (this.getFormatForADG(locale)) {
            return ADG_DATE_FORMAT;
        }
        DateFormat format = DateFormat.getDateInstance(2, locale);
        return ((SimpleDateFormat)format).toPattern();
    }

    public String getFormattedRelativeTime(Instant instant) {
        return this.getFormattedRelativeTime(instant, AuthenticatedUserThreadLocal.get());
    }

    String getFormattedRelativeTime(Instant instant, ConfluenceUser user) {
        Message format = new FriendlyDateFormatter(this.clock.getCurrentDate(), this.userPreferencesAccessor.getConfluenceUserPreferences((User)user).getDateFormatter(this.formatSettingsManager, this.localeManager)).getFormatMessage(Date.from(instant));
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)user)).getText(format);
    }
}

