/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content.finder;

import com.atlassian.confluence.api.impl.service.content.factory.ContentFactory;
import com.atlassian.confluence.api.impl.service.content.finder.ContentFetcher;
import com.atlassian.confluence.api.impl.service.content.finder.ContentFinderImpl;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.pagination.ContentCursor;
import com.atlassian.confluence.api.model.pagination.CursorType;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.api.model.pagination.PaginationBatch;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.dmz.pages.CommentManagerInternal;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class CommentFetcher
implements ContentFetcher {
    private final ContentFinderImpl contentFinder;
    private final PaginationService paginationService;
    private final ContentFactory contentFactory;
    private final SpaceManager spaceManager;
    private final CommentManagerInternal commentManager;

    public CommentFetcher(ContentFinderImpl contentFinder, PaginationService paginationService, ContentFactory contentFactory, CommentManagerInternal commentManager, SpaceManager spaceManager) {
        this.contentFinder = contentFinder;
        this.paginationService = paginationService;
        this.contentFactory = contentFactory;
        this.spaceManager = spaceManager;
        this.commentManager = commentManager;
    }

    @Override
    public PageResponse<Content> fetch(LimitedRequest request) throws BadRequestException {
        if (this.contentFinder.getContentContainerId() != null) {
            return PageResponseImpl.empty((boolean)false, (LimitedRequest)request);
        }
        if (this.contentFinder.getSpaces().size() == 1) {
            return this.fetchBySpace(request);
        }
        Optional<Long> totalContentCount = this.contentFinder.getTotalContentCountIfExpand(() -> this.commentManager.countCommentByStatuses(this.contentFinder.getStatuses()));
        PageResponse<Content> pageResponse = this.fetchAllContent(request);
        return PageResponseImpl.from(pageResponse, totalContentCount);
    }

    protected PageResponse<Content> fetchBySpace(LimitedRequest request) {
        Space space = this.spaceManager.getSpace(this.contentFinder.getSpaces().get(0).getKey());
        if (space == null) {
            return PageResponseImpl.empty((boolean)false);
        }
        if (request.getCursor() == null) {
            return PageResponseImpl.empty((boolean)false);
        }
        Optional<Long> totalContentCount = this.contentFinder.getTotalContentCountIfExpand(() -> this.commentManager.countSpaceCommentByStatuses(space, this.contentFinder.getStatuses()));
        PageResponse<Content> pageResponse = this.fetchBySpaceWithCursor(request, space);
        return PageResponseImpl.from(pageResponse, totalContentCount);
    }

    private PageResponse<Content> fetchBySpaceWithCursor(LimitedRequest request, Space space) {
        return this.doPaginationRequestWithCursor(request, limitedRequest -> this.commentManager.scanFilteredComments(space, this.contentFinder.getStatuses(), limitedRequest, new Predicate[0]), this.contentFinder.getExpansions());
    }

    private PageResponse<Content> doPaginationRequestWithCursor(LimitedRequest request, Function<LimitedRequest, PageResponse<Comment>> visibleContentScanner, Expansions expansions) {
        this.validateCursor(request);
        return this.paginationService.performPaginationListRequestWithCursor(request, visibleContentScanner, items -> this.contentFactory.buildFrom((Iterable<? extends ContentEntityObject>)items, expansions), CommentFetcher::calculateCursorFromContent);
    }

    private PageResponse<Content> doPaginationRequest(LimitedRequest request, PaginationBatch<? extends Comment> paginationBatch, Expansions expansions) {
        return this.paginationService.performPaginationListRequest(request, paginationBatch, items -> this.contentFactory.buildFrom((Iterable<? extends ContentEntityObject>)items, expansions));
    }

    private PageResponse<Content> fetchAllContent(LimitedRequest request) {
        if (request.getCursor() == null) {
            return this.fetchAllContentWithOffset(request);
        }
        return this.fetchAllContentWithCursor(request);
    }

    private void validateCursor(LimitedRequest request) {
        CursorType requestedCursorType = request.getCursor().getCursorType();
        if (!requestedCursorType.equals((Object)CursorType.COMMENT)) {
            throw new IllegalArgumentException(String.format("Cursor type is incorrect. Received: %s, but %s was expected", request.getCursor().getCursorType(), CursorType.COMMENT.getType()));
        }
    }

    private PageResponse<Content> fetchAllContentWithCursor(LimitedRequest request) {
        return this.doPaginationRequestWithCursor(request, limitedRequest -> this.commentManager.scanFilteredComments(this.contentFinder.getStatuses(), request, new Predicate[0]), this.contentFinder.getExpansions());
    }

    private PageResponse<Content> fetchAllContentWithOffset(LimitedRequest request) {
        return this.doPaginationRequest(request, (PaginationBatch<? extends Comment>)((PaginationBatch)limitedRequest -> this.commentManager.scanFilteredComments(this.contentFinder.getStatuses(), request, new Predicate[0])), this.contentFinder.getExpansions());
    }

    private static ContentCursor calculateCursorFromContent(Comment content, boolean isReverse) {
        return ContentCursor.createCursor((boolean)isReverse, (long)content.getId(), (CursorType)CursorType.COMMENT);
    }
}

