/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.api.impl.service.content;

import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.CategoryService;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.LabelPermissionEnforcer;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class CategoryServiceImpl
implements CategoryService {
    private final SpaceManagerInternal spaceManager;
    private final LabelManager labelManager;
    private final LabelPermissionEnforcer labelPermissionEnforcer;

    public CategoryServiceImpl(SpaceManagerInternal spaceManager, LabelManager labelManager, LabelPermissionEnforcer labelPermissionEnforcer) {
        this.spaceManager = spaceManager;
        this.labelManager = labelManager;
        this.labelPermissionEnforcer = labelPermissionEnforcer;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="The validator will throw an exception if the space or category is not found")
    public void removeCategory(String spaceKey, String categoryName) throws ServiceException {
        this.validator().validateEditCategory(spaceKey, categoryName).throwIfNotSuccessful("Cannot remove category");
        Label category = this.labelManager.getLabel(categoryName, Namespace.TEAM);
        Space space = this.spaceManager.getSpace(spaceKey);
        SpaceDescription spaceDescription = space.getDescription();
        this.labelManager.removeLabel((Labelable)spaceDescription, category);
    }

    public CategoryService.Validator validator() {
        return new ValidatorImpl();
    }

    private final class ValidatorImpl
    implements CategoryService.Validator {
        private ValidatorImpl() {
        }

        public ValidationResult validateEditCategory(String spaceKey, String categoryName) {
            boolean spaceExists;
            boolean categoryExists;
            Label category = CategoryServiceImpl.this.labelManager.getLabel(categoryName, Namespace.TEAM);
            boolean bl = categoryExists = category != null;
            if (!categoryExists) {
                return new SimpleValidationResult.Builder().authorized(true).addError("Cannot find category with name: " + categoryName, new Object[0]).withExceptionSupplier(ServiceExceptionSupplier.notFoundExceptionSupplier()).build();
            }
            Space space = CategoryServiceImpl.this.spaceManager.getSpace(spaceKey);
            boolean bl2 = spaceExists = space != null;
            if (!spaceExists) {
                return new SimpleValidationResult.Builder().authorized(true).addError("Unknown space key: " + spaceKey, new Object[0]).withExceptionSupplier(ServiceExceptionSupplier.notFoundExceptionSupplier()).build();
            }
            SpaceDescription spaceDescription = space.getDescription();
            boolean canEditCategoriesOnSpace = CategoryServiceImpl.this.labelPermissionEnforcer.userCanEditLabel(category, (Labelable)spaceDescription);
            if (!canEditCategoriesOnSpace) {
                return new SimpleValidationResult.Builder().authorized(false).addError("User is not permitted to edit categories for the space: " + spaceKey, new Object[0]).withExceptionSupplier(ServiceExceptionSupplier.permissionExceptionExceptionSupplier()).build();
            }
            return SimpleValidationResult.VALID;
        }
    }
}

