package com.atlassian.confluence.compat.api.service.accessmode;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Specifies that the annotated method (or all methods in the class, or all the methods in all the classes in the package)
 * should be bypassed by read-only access check.
 * WARNING: This annotation must be used for admin actions only or user usage tracking services, e.g. recently viewed, analytics
 *
 * @since 1.0.0
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.METHOD, ElementType.TYPE, ElementType.PACKAGE})
public @interface ReadOnlyAccessAllowed {
}