/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.vcache;

import com.atlassian.vcache.internal.BegunTransactionalActivityHandler;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.VCacheLifecycleManager;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.support.TransactionSynchronization;

class VCacheTransactionSyncHandler
implements BegunTransactionalActivityHandler {
    private static final Logger log = LoggerFactory.getLogger(VCacheTransactionSyncHandler.class);
    private final Supplier<VCacheLifecycleManager> lifecycleManagerRef;
    private final Consumer<TransactionSynchronization> txSynchronizationRegistrar;

    VCacheTransactionSyncHandler(Consumer<TransactionSynchronization> txSynchronizationRegistrar, Supplier<VCacheLifecycleManager> lifecycleManagerRef) {
        this.txSynchronizationRegistrar = txSynchronizationRegistrar;
        this.lifecycleManagerRef = lifecycleManagerRef;
    }

    public void onRequest(final RequestContext context) {
        final VCacheLifecycleManager lifecycleManager = this.lifecycleManagerRef.get();
        if (lifecycleManager != null) {
            log.debug("Registering sync for new transaction on {}", (Object)context);
            this.txSynchronizationRegistrar.accept(new TransactionSynchronization(){

                public void afterCompletion(int status) {
                    if (status == 0) {
                        log.debug("Syncing tx on commit on {}", (Object)context);
                        lifecycleManager.transactionSync(context);
                    } else {
                        Set discardedCaches = lifecycleManager.transactionDiscard(context);
                        log.debug("Transaction completed with non-commit status {}, discarded pending operations on caches {}", (Object)status, (Object)discardedCaches);
                    }
                }
            });
        } else {
            log.error("No VCacheLifecycleManager is available, cannot initialise transaction sync.");
        }
    }

    public void onCleanUp(RequestContext requestContext) {
        VCacheLifecycleManager lifecycleManager = this.lifecycleManagerRef.get();
        if (lifecycleManager != null) {
            Set unsynchronizedCacheNames = lifecycleManager.transactionDiscard(requestContext);
            if (!unsynchronizedCacheNames.isEmpty()) {
                log.error("Unsynchronized transactional caches found whilst cleaning up VCache request context: {}", (Object)unsynchronizedCacheNames);
            }
        } else {
            log.warn("No VCache LifecycleManager available, cannot verify unsynchronized caches");
        }
    }
}

