/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.vcache;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.impl.vcache.VCacheRequestContextManager;
import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Throwables;
import io.atlassian.util.concurrent.Lazy;
import java.io.IOException;
import java.util.function.Supplier;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class VCacheRequestContextFilter
extends AbstractHttpFilter {
    private static final Logger log = LoggerFactory.getLogger(VCacheRequestContextFilter.class);
    private final Supplier<VCacheRequestContextManager> requestContextManagerRef = Lazy.supplier(() -> (VCacheRequestContextManager)ContainerManager.getComponent((String)"vcacheRequestContextManager"));

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (ContainerManager.isContainerSetup()) {
            try {
                log.debug("Setting up vcache request context for {}", (Object)request.getRequestURI());
                VCacheRequestContextManager requestContextManager = this.requestContextManagerRef.get();
                requestContextManager.doInRequestContext(() -> {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return null;
                });
                log.debug("Cleared vcache request context for {}", (Object)request.getRequestURI());
            }
            catch (IOException | ServletException ex) {
                throw ex;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }
}

