/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.hibernate;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsDefaultsProvider;
import com.atlassian.cache.ManagedCache;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.hibernate.cache.ehcache.internal.EhcacheRegionFactory;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class HibernateJvmVCacheRegionFactory
extends EhcacheRegionFactory {
    private final CacheManager atlassianCacheManager;
    private final CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider;

    public HibernateJvmVCacheRegionFactory(CacheManager atlassianCacheManager, CacheSettingsDefaultsProvider cacheSettingsDefaultsProvider) {
        this.atlassianCacheManager = Objects.requireNonNull(atlassianCacheManager);
        this.cacheSettingsDefaultsProvider = Objects.requireNonNull(cacheSettingsDefaultsProvider);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, SessionFactoryImplementor sessionFactory) {
        return this.withCacheSettingSynced(regionName, () -> super.buildQueryResultsRegion(regionName, sessionFactory));
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, SessionFactoryImplementor sessionFactory) {
        return this.withCacheSettingSynced(regionName, () -> super.buildTimestampsRegion(regionName, sessionFactory));
    }

    @VisibleForTesting
    <T> T withCacheSettingSynced(String cacheName, Supplier<T> regionSupplier) {
        T region = regionSupplier.get();
        this.atlassianCacheManager.getCache(cacheName);
        ManagedCache cache = this.atlassianCacheManager.getManagedCache(cacheName);
        if (cache != null) {
            CacheSettings settings = this.cacheSettingsDefaultsProvider.getDefaults(cacheName);
            Optional.ofNullable(settings.getMaxEntries()).ifPresent(arg_0 -> ((ManagedCache)cache).updateMaxEntries(arg_0));
            Optional.ofNullable(settings.getExpireAfterAccess()).ifPresent(duration -> cache.updateExpireAfterAccess(duration.longValue(), TimeUnit.MILLISECONDS));
            Optional.ofNullable(settings.getExpireAfterWrite()).ifPresent(duration -> cache.updateExpireAfterWrite(duration.longValue(), TimeUnit.MILLISECONDS));
        }
        return region;
    }
}

