/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.ehcache;

import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.confluence.cache.ehcache.ConfluenceEhCache;
import com.atlassian.confluence.cache.ehcache.ConfluenceManagedCache;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheManager
implements CacheManager {
    private static final Logger startupLog = LoggerFactory.getLogger((String)"com.atlassian.confluence.lifecycle");
    private static final String EHCACHE_CONFIG_PATH = "ehcache.xml";
    private final Set<String> cachedReferenceNames = Collections.synchronizedSet(new HashSet());
    private final Collection<String> nonFlushableCacheNames;
    private final CacheManager atlassianCacheDelegate;
    private final net.sf.ehcache.CacheManager ehCacheDelegateManager;

    public EhCacheManager(Collection<String> nonFlushableCacheNames) {
        startupLog.info("Loading EhCache cache manager");
        this.nonFlushableCacheNames = nonFlushableCacheNames;
        this.ehCacheDelegateManager = EhCacheManager.loadAndConfigureDelegate();
        this.atlassianCacheDelegate = new com.atlassian.cache.ehcache.EhCacheManager(this.ehCacheDelegateManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static net.sf.ehcache.CacheManager loadAndConfigureDelegate() {
        InputStream inputStream = null;
        try {
            inputStream = ClassLoaderUtils.getResourceAsStream((String)EHCACHE_CONFIG_PATH, EhCacheManager.class);
            net.sf.ehcache.CacheManager cacheManager = net.sf.ehcache.CacheManager.create((InputStream)inputStream);
            return cacheManager;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public void flushCaches() {
        String[] cacheNames = this.ehCacheDelegateManager.getCacheNames();
        ImmutableSet allNonFlushableCacheNames = ImmutableSet.builder().addAll(this.nonFlushableCacheNames).addAll(Iterables.transform((Iterable)Iterables.filter((Iterable)this.atlassianCacheDelegate.getManagedCaches(), (Predicate)Predicates.not(this.flushable())), this.cacheName())).build();
        for (String cacheName : cacheNames) {
            if (allNonFlushableCacheNames.contains(cacheName)) continue;
            this.ehCacheDelegateManager.getCache(cacheName).removeAll();
        }
    }

    private Predicate<ManagedCache> flushable() {
        return new Predicate<ManagedCache>(){

            public boolean apply(ManagedCache cache) {
                return cache.isFlushable();
            }
        };
    }

    private Function<ManagedCache, String> cacheName() {
        return new Function<ManagedCache, String>(){

            public String apply(ManagedCache cache) {
                return cache.getName();
            }
        };
    }

    net.sf.ehcache.CacheManager getDelegateEhCacheManager() {
        return this.ehCacheDelegateManager;
    }

    public Collection<com.atlassian.cache.Cache<?, ?>> getCaches() {
        ArrayList ret = Lists.newArrayList();
        for (String cacheName : this.ehCacheDelegateManager.getCacheNames()) {
            if (this.cachedReferenceNames.contains(cacheName)) continue;
            ret.add(this.getCache(cacheName));
        }
        return ret;
    }

    private <K, V> ConfluenceEhCache<K, V> wrapCache(com.atlassian.cache.Cache<K, V> cache) {
        Cache ehCache = this.ehCacheDelegateManager.getCache(cache.getName());
        CacheConfiguration ehCacheConfig = ehCache.getCacheConfiguration();
        return new ConfluenceEhCache<K, V>(cache, ehCacheConfig);
    }

    public <K, V> ConfluenceEhCache<K, V> getCache(String name) {
        return this.wrapCache(this.atlassianCacheDelegate.getCache(name));
    }

    public <K, V> ConfluenceEhCache<K, V> getCache(String name, Class<K> keyType, Class<V> valueType) {
        return this.wrapCache(this.atlassianCacheDelegate.getCache(name, keyType, valueType));
    }

    public Collection<ManagedCache> getManagedCaches() {
        return Collections2.transform((Collection)this.atlassianCacheDelegate.getManagedCaches(), (Function)new Function<ManagedCache, ManagedCache>(){

            public ManagedCache apply(ManagedCache cache) {
                return EhCacheManager.this.wrapManagedCache(cache);
            }
        });
    }

    public ManagedCache getManagedCache(@NotNull String name) {
        ManagedCache mc = this.atlassianCacheDelegate.getManagedCache(name);
        return null == mc ? mc : this.wrapManagedCache(mc);
    }

    private ConfluenceManagedCache wrapManagedCache(ManagedCache cache) {
        return new ConfluenceManagedCache(cache, !this.nonFlushableCacheNames.contains(cache.getName()));
    }

    public <V> CachedReference<V> getCachedReference(String name, Supplier<V> supplier) {
        CachedReference result = this.atlassianCacheDelegate.getCachedReference(name, supplier);
        this.cachedReferenceNames.add(name);
        return result;
    }

    public <V> CachedReference<V> getCachedReference(String name, Supplier<V> supplier, CacheSettings settings) {
        CachedReference result = this.atlassianCacheDelegate.getCachedReference(name, supplier, settings);
        this.cachedReferenceNames.add(name);
        return result;
    }

    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier) {
        CachedReference result = this.atlassianCacheDelegate.getCachedReference(owningClass, name, supplier);
        this.cachedReferenceNames.add(name);
        return result;
    }

    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier, CacheSettings settings) {
        CachedReference result = this.atlassianCacheDelegate.getCachedReference(owningClass, name, supplier, settings);
        this.cachedReferenceNames.add(name);
        return result;
    }

    public <K, V> ConfluenceEhCache<K, V> getCache(Class<?> owningClass, String name) {
        return this.wrapCache(this.atlassianCacheDelegate.getCache(owningClass, name));
    }

    public <K, V> ConfluenceEhCache<K, V> getCache(String name, CacheLoader<K, V> loader) {
        return this.wrapCache(this.atlassianCacheDelegate.getCache(name, loader));
    }

    public <K, V> ConfluenceEhCache<K, V> getCache(String name, CacheLoader<K, V> loader, CacheSettings settings) {
        return this.wrapCache(this.atlassianCacheDelegate.getCache(name, loader, settings));
    }
}

